/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.signers;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.AsymmetricBlockCipher;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.CipherParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.CryptoException;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.Digest;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.params.RSAKeyParameters;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.crypto.signers.ISOTrailers;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Arrays;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class X931Signer {
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private RSAKeyParameters kParam;
    private int trailer;
    private int keyBits;
    private byte[] block;

    public X931Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl) {
        this.cipher = asymmetricBlockCipher;
        this.digest = digest;
        if (bl) {
            this.trailer = 188;
        } else {
            Integer n = ISOTrailers.getTrailer(digest);
            if (n != null) {
                this.trailer = n;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest: " + digest.getAlgorithmName());
            }
        }
    }

    public X931Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.kParam = (RSAKeyParameters)cipherParameters;
        this.cipher.init(bl, this.kParam);
        this.keyBits = this.kParam.getModulus().bitLength();
        this.block = new byte[(this.keyBits + 7) / 8];
        this.reset();
    }

    private void clearBlock(byte[] byArray) {
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public void update(byte by) {
        this.digest.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public void reset() {
        this.digest.reset();
    }

    public byte[] generateSignature() throws CryptoException {
        this.createSignatureBlock(this.trailer);
        BigInteger bigInteger = new BigInteger(1, this.cipher.processBlock(this.block, 0, this.block.length));
        this.clearBlock(this.block);
        bigInteger = bigInteger.min(this.kParam.getModulus().subtract(bigInteger));
        int n = BigIntegers.getUnsignedByteLength(this.kParam.getModulus());
        return BigIntegers.asUnsignedByteArray(n, bigInteger);
    }

    private void createSignatureBlock(int n) {
        int n2;
        int n3 = this.digest.getDigestSize();
        if (n == 188) {
            n2 = this.block.length - n3 - 1;
            this.digest.doFinal(this.block, n2);
            this.block[this.block.length - 1] = -68;
        } else {
            n2 = this.block.length - n3 - 2;
            this.digest.doFinal(this.block, n2);
            this.block[this.block.length - 2] = (byte)(n >>> 8);
            this.block[this.block.length - 1] = (byte)n;
        }
        this.block[0] = 107;
        for (int i = n2 - 2; i != 0; --i) {
            this.block[i] = -69;
        }
        this.block[n2 - 1] = -70;
    }

    public boolean verifySignature(byte[] byArray) {
        BigInteger bigInteger;
        try {
            this.block = this.cipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        BigInteger bigInteger2 = new BigInteger(1, this.block);
        if ((bigInteger2.intValue() & 0xF) == 12) {
            bigInteger = bigInteger2;
        } else {
            bigInteger2 = this.kParam.getModulus().subtract(bigInteger2);
            if ((bigInteger2.intValue() & 0xF) == 12) {
                bigInteger = bigInteger2;
            } else {
                return false;
            }
        }
        this.createSignatureBlock(this.trailer);
        byte[] byArray2 = BigIntegers.asUnsignedByteArray(this.block.length, bigInteger);
        boolean bl = Arrays.constantTimeAreEqual(this.block, byArray2);
        if (this.trailer == 15052 && !bl) {
            this.block[this.block.length - 2] = 64;
            bl = Arrays.constantTimeAreEqual(this.block, byArray2);
        }
        this.clearBlock(this.block);
        this.clearBlock(byArray2);
        return bl;
    }
}

