/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert;

import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Encodable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1EncodableVector;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Integer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1Object;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERBitString;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.DERSequence;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x500.X500Name;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Certificate;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.DeltaCertificateDescriptor;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Extension;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.ExtensionsGenerator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.TBSCertificate;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.Time;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.CertIOException;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.DeltaCertificateTool;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.cert.X509CertificateHolder;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.operator.ContentSigner;
import io.opentelemetry.testing.internal.armeria.internal.shaded.bouncycastle.util.Exceptions;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;

public class X509v3CertificateBuilder {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private ExtensionsGenerator extGenerator;

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Date date, Date date2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(x500Name, bigInteger, new Time(date), new Time(date2), x500Name2, subjectPublicKeyInfo);
    }

    public X509v3CertificateBuilder(X500Name x500Name, BigInteger bigInteger, Time time, Time time2, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.tbsGen.setSerialNumber(new ASN1Integer(bigInteger));
        this.tbsGen.setIssuer(x500Name);
        this.tbsGen.setStartDate(time);
        this.tbsGen.setEndDate(time2);
        this.tbsGen.setSubject(x500Name2);
        this.tbsGen.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
        this.extGenerator = new ExtensionsGenerator();
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) throws CertIOException {
        try {
            this.extGenerator.addExtension(aSN1ObjectIdentifier, bl, aSN1Encodable);
        }
        catch (IOException iOException) {
            throw new CertIOException("cannot encode extension: " + iOException.getMessage(), iOException);
        }
        return this;
    }

    public X509CertificateHolder build(ContentSigner contentSigner) {
        Object object;
        ASN1Object aSN1Object;
        AlgorithmIdentifier algorithmIdentifier = contentSigner.getAlgorithmIdentifier();
        this.tbsGen.setSignature(algorithmIdentifier);
        if (!this.extGenerator.isEmpty()) {
            aSN1Object = this.extGenerator.getExtension(Extension.deltaCertificateDescriptor);
            if (aSN1Object != null) {
                object = DeltaCertificateTool.trimDeltaCertificateDescriptor(DeltaCertificateDescriptor.getInstance(((Extension)aSN1Object).getParsedValue()), this.tbsGen.generateTBSCertificate(), this.extGenerator.generate());
                try {
                    this.extGenerator.replaceExtension(Extension.deltaCertificateDescriptor, ((Extension)aSN1Object).isCritical(), (ASN1Encodable)object);
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("unable to replace deltaCertificateDescriptor: " + iOException.getMessage());
                }
            }
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        try {
            aSN1Object = this.tbsGen.generateTBSCertificate();
            object = X509v3CertificateBuilder.generateSig(contentSigner, aSN1Object);
            return new X509CertificateHolder(X509v3CertificateBuilder.generateStructure((TBSCertificate)aSN1Object, algorithmIdentifier, object));
        }
        catch (IOException iOException) {
            throw Exceptions.illegalArgumentException("cannot produce certificate signature", iOException);
        }
    }

    private static byte[] generateSig(ContentSigner contentSigner, ASN1Object aSN1Object) throws IOException {
        OutputStream outputStream = contentSigner.getOutputStream();
        aSN1Object.encodeTo(outputStream, "DER");
        outputStream.close();
        return contentSigner.getSignature();
    }

    private static Certificate generateStructure(TBSCertificate tBSCertificate, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(tBSCertificate);
        aSN1EncodableVector.add(algorithmIdentifier);
        aSN1EncodableVector.add(new DERBitString(byArray));
        return Certificate.getInstance(new DERSequence(aSN1EncodableVector));
    }
}

