/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.websocket;

import io.opentelemetry.testing.internal.armeria.common.HttpRequestWriter;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextExtension;
import io.opentelemetry.testing.internal.armeria.internal.common.websocket.WebSocketFrameDecoder;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;

final class WebSocketServiceFrameDecoder
extends WebSocketFrameDecoder {
    private final ServiceRequestContext ctx;

    WebSocketServiceFrameDecoder(ServiceRequestContext ctx, int maxFramePayloadLength, boolean allowMaskMismatch, boolean aggregateContinuation) {
        super(maxFramePayloadLength, allowMaskMismatch, aggregateContinuation);
        this.ctx = ctx;
    }

    @Override
    protected boolean expectMaskedFrames() {
        return true;
    }

    @Override
    protected void onCloseFrameRead() {
        RequestContextExtension ctxExtension = this.ctx.as(RequestContextExtension.class);
        assert (ctxExtension != null);
        Request request = ctxExtension.originalRequest();
        assert (request instanceof HttpRequestWriter) : request;
        ((HttpRequestWriter)request).close();
    }
}

