/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotatedDocServicePlugin;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.AnnotationUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.DefaultDescriptiveTypeInfoProvider;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.annotation.Description;
import io.opentelemetry.testing.internal.armeria.server.docs.ContainerTypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.DescriptionInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.DescriptiveTypeInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.DescriptiveTypeInfoProvider;
import io.opentelemetry.testing.internal.armeria.server.docs.FieldInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.FieldRequirement;
import io.opentelemetry.testing.internal.armeria.server.docs.StructInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignatureType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

enum ReflectiveDescriptiveTypeInfoProvider implements DescriptiveTypeInfoProvider
{
    INSTANCE;


    @Override
    @Nonnull
    public DescriptiveTypeInfo newDescriptiveTypeInfo(Object typeDescriptor) {
        Class clazz = (Class)typeDescriptor;
        List fieldInfos = Arrays.stream(clazz.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).map(ReflectiveDescriptiveTypeInfoProvider::fieldInfo).collect(ImmutableList.toImmutableList());
        DescriptionInfo descriptionInfo = ReflectiveDescriptiveTypeInfoProvider.descriptionInfo(clazz);
        return new StructInfo(clazz.getName(), fieldInfos, descriptionInfo);
    }

    private static FieldInfo fieldInfo(Field field) {
        FieldRequirement fieldRequirement;
        Type type = field.getGenericType();
        TypeSignature typeSignature = AnnotatedDocServicePlugin.toTypeSignature(type);
        DescriptionInfo descriptionInfo = ReflectiveDescriptiveTypeInfoProvider.descriptionInfo(field);
        if (typeSignature.type() == TypeSignatureType.OPTIONAL) {
            typeSignature = ((ContainerTypeSignature)typeSignature).typeParameters().get(0);
            fieldRequirement = FieldRequirement.OPTIONAL;
        } else {
            fieldRequirement = DefaultDescriptiveTypeInfoProvider.isNullable(field) ? FieldRequirement.OPTIONAL : FieldRequirement.REQUIRED;
        }
        return FieldInfo.builder(field.getName(), typeSignature).requirement(fieldRequirement).descriptionInfo(descriptionInfo).build();
    }

    private static DescriptionInfo descriptionInfo(AnnotatedElement element) {
        Description description = AnnotationUtil.findFirst(element, Description.class);
        if (description == null) {
            return DescriptionInfo.empty();
        }
        return DescriptionInfo.from(description);
    }
}

