/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.FieldMasker;
import io.opentelemetry.testing.internal.armeria.internal.common.logging.MaskerAttributeKeys;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.BeanFieldMaskerCache;
import io.opentelemetry.testing.internal.armeria.internal.server.annotation.JacksonBeanFieldInfo;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.databind.BeanDescription;
import io.opentelemetry.testing.internal.jackson.databind.BeanProperty;
import io.opentelemetry.testing.internal.jackson.databind.JsonMappingException;
import io.opentelemetry.testing.internal.jackson.databind.JsonSerializer;
import io.opentelemetry.testing.internal.jackson.databind.SerializationConfig;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import io.opentelemetry.testing.internal.jackson.databind.ser.BeanSerializerModifier;
import io.opentelemetry.testing.internal.jackson.databind.ser.ContextualSerializer;
import io.opentelemetry.testing.internal.jackson.databind.ser.ResolvableSerializer;
import java.io.IOException;

final class MaskingBeanSerializerModifier
extends BeanSerializerModifier {
    private static final long serialVersionUID = -3932539093396454693L;
    private final BeanFieldMaskerCache fieldMaskerCache;

    MaskingBeanSerializerModifier(BeanFieldMaskerCache fieldMaskerCache) {
        this.fieldMaskerCache = fieldMaskerCache;
    }

    @Override
    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return new MaskingJsonSerializer(serializer, this.fieldMaskerCache, beanDesc, null);
    }

    private static final class MaskingJsonSerializer<T>
    extends JsonSerializer<T>
    implements ContextualSerializer,
    ResolvableSerializer {
        private final JsonSerializer<T> delegate;
        private final BeanFieldMaskerCache fieldMaskerCache;
        private final BeanDescription classBean;
        @Nullable
        private final BeanProperty property;
        private final FieldMasker mapper;

        MaskingJsonSerializer(JsonSerializer<T> delegate, BeanFieldMaskerCache fieldMaskerCache, BeanDescription classBean, @Nullable BeanProperty property) {
            this.delegate = delegate;
            this.fieldMaskerCache = fieldMaskerCache;
            this.classBean = classBean;
            this.property = property;
            this.mapper = property != null ? fieldMaskerCache.fieldMasker(new JacksonBeanFieldInfo(classBean, property)) : FieldMasker.noMask();
        }

        @Override
        public Class<T> handledType() {
            return this.delegate.handledType();
        }

        @Override
        public void serialize(T o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            RequestContext ctx = (RequestContext)serializerProvider.getAttribute(MaskerAttributeKeys.REQUEST_CONTEXT_KEY);
            Object masked = this.mapper.mask(ctx, o);
            if (masked == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                return;
            }
            Class<?> outClass = this.mapper.mappedClass(o.getClass());
            if (outClass != o.getClass()) {
                jsonGenerator.writeObject(masked);
                return;
            }
            Object t = masked;
            this.delegate.serialize(t, jsonGenerator, serializerProvider);
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            Preconditions.checkState(this.property == null);
            return new MaskingJsonSerializer<T>(this.delegate, this.fieldMaskerCache, this.classBean, property);
        }

        @Override
        public void resolve(SerializerProvider provider) throws JsonMappingException {
            if (this.delegate instanceof ResolvableSerializer) {
                ((ResolvableSerializer)((Object)this.delegate)).resolve(provider);
            }
        }
    }
}

