/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.logging.BeanFieldInfo;
import io.opentelemetry.testing.internal.armeria.common.logging.BeanFieldMaskerSelector;
import io.opentelemetry.testing.internal.armeria.common.logging.FieldMasker;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class BeanFieldMaskerCache {
    private final List<BeanFieldMaskerSelector> selectors;
    private final Map<BeanFieldInfo, FieldMasker> fieldMaskers = new ConcurrentHashMap<BeanFieldInfo, FieldMasker>();

    BeanFieldMaskerCache(List<BeanFieldMaskerSelector> selectors) {
        this.selectors = selectors;
    }

    FieldMasker fieldMasker(BeanFieldInfo annotationHolder) {
        return this.fieldMaskers.computeIfAbsent(annotationHolder, holder -> {
            for (BeanFieldMaskerSelector selector : this.selectors) {
                FieldMasker masker = selector.fieldMasker(holder);
                Preconditions.checkArgument(masker != null, "%s.fieldMasker() returned null for (%s)", (Object)selector.getClass().getName(), holder);
                if (masker == FieldMasker.fallthrough()) continue;
                return masker;
            }
            return FieldMasker.noMask();
        });
    }
}

