/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.websocket;

import io.opentelemetry.testing.internal.armeria.common.Bytes;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.stream.HttpDecoder;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamDecoderInput;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamDecoderOutput;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocket;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketCloseStatus;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketFrame;
import io.opentelemetry.testing.internal.armeria.common.websocket.WebSocketFrameType;
import io.opentelemetry.testing.internal.armeria.internal.common.websocket.Utf8Validator;
import io.opentelemetry.testing.internal.armeria.internal.common.websocket.WebSocketUtil;
import io.opentelemetry.testing.internal.armeria.server.websocket.WebSocketProtocolViolationException;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebSocketFrameDecoder
implements HttpDecoder<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketFrameDecoder.class);
    private final int maxFramePayloadLength;
    private final boolean allowMaskMismatch;
    private final boolean aggregateContinuation;
    private final List<WebSocketFrame> aggregatingFrames = new ArrayList<WebSocketFrame>();
    private long aggregatingFramesLength;
    @Nullable
    private WebSocket outboundFrames;
    private int fragmentedFramesCount;
    private boolean finalFragment;
    private boolean frameMasked;
    private int frameRsv;
    private int frameOpcode;
    private long framePayloadLength;
    private int mask;
    private int framePayloadLen1;
    private boolean receivedClosingHandshake;
    private State state = State.READING_FIRST;

    protected WebSocketFrameDecoder(int maxFramePayloadLength, boolean allowMaskMismatch, boolean aggregateContinuation) {
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.allowMaskMismatch = allowMaskMismatch;
        this.aggregateContinuation = aggregateContinuation;
    }

    public void setOutboundWebSocket(WebSocket outboundFrames) {
        this.outboundFrames = outboundFrames;
    }

    @Override
    public void process(StreamDecoderInput in, StreamDecoderOutput<WebSocketFrame> out) throws Exception {
        block7: while (in.readableBytes() > 0) {
            if (this.receivedClosingHandshake) {
                in.close();
                return;
            }
            switch (this.state.ordinal()) {
                case 0: {
                    this.framePayloadLength = 0L;
                    byte b = in.readByte();
                    this.finalFragment = (b & 0x80) != 0;
                    this.frameRsv = (b & 0x70) >> 4;
                    this.frameOpcode = b & 0xF;
                    logger.trace("Decoding a WebSocket Frame. opcode: {}, finalFragment: {}", (Object)this.frameOpcode, (Object)this.finalFragment);
                    this.state = State.READING_SECOND;
                }
                case 1: {
                    if (in.readableBytes() == 0) {
                        return;
                    }
                    byte b = in.readByte();
                    this.frameMasked = (b & 0x80) != 0;
                    this.framePayloadLen1 = b & 0x7F;
                    if (this.frameRsv != 0) {
                        throw this.protocolViolation("RSV != 0 and no extension negotiated, RSV:" + this.frameRsv);
                    }
                    if (!this.allowMaskMismatch && this.expectMaskedFrames() != this.frameMasked) {
                        throw this.protocolViolation("received a frame that is not masked as expected");
                    }
                    if (this.frameOpcode > 7) {
                        if (!this.finalFragment) {
                            throw this.protocolViolation("fragmented control frame");
                        }
                        if (this.framePayloadLen1 > 125) {
                            throw this.protocolViolation("control frame with payload length > 125 octets");
                        }
                        if (this.frameOpcode != WebSocketFrameType.CLOSE.opcode() && this.frameOpcode != WebSocketFrameType.PING.opcode() && this.frameOpcode != WebSocketFrameType.PONG.opcode()) {
                            throw this.protocolViolation("control frame using reserved opcode " + this.frameOpcode);
                        }
                        if (this.frameOpcode == WebSocketFrameType.CLOSE.opcode() && this.framePayloadLen1 == 1) {
                            throw this.protocolViolation("received close control frame with payload len 1");
                        }
                    } else {
                        if (this.frameOpcode != WebSocketFrameType.CONTINUATION.opcode() && this.frameOpcode != WebSocketFrameType.TEXT.opcode() && this.frameOpcode != WebSocketFrameType.BINARY.opcode()) {
                            throw this.protocolViolation("data frame using reserved opcode " + this.frameOpcode);
                        }
                        if (this.fragmentedFramesCount == 0) {
                            if (this.frameOpcode == WebSocketFrameType.CONTINUATION.opcode()) {
                                throw this.protocolViolation("received continuation data frame outside fragmented message");
                            }
                        } else if (this.frameOpcode != WebSocketFrameType.CONTINUATION.opcode()) {
                            throw this.protocolViolation("received non-continuation data frame while inside fragmented message");
                        }
                    }
                    this.state = State.READING_SIZE;
                }
                case 2: {
                    if (this.framePayloadLen1 == 126) {
                        if (in.readableBytes() < 2) {
                            return;
                        }
                        this.framePayloadLength = in.readUnsignedShort();
                        if (this.framePayloadLength < 126L) {
                            throw this.protocolViolation("invalid data frame length (not using minimal length encoding)");
                        }
                    } else if (this.framePayloadLen1 == 127) {
                        if (in.readableBytes() < 8) {
                            return;
                        }
                        this.framePayloadLength = in.readLong();
                        if (this.framePayloadLength < 0L) {
                            throw this.protocolViolation("invalid data frame length (negative length)");
                        }
                        if (this.framePayloadLength < 65536L) {
                            throw this.protocolViolation("invalid data frame length (not using minimal length encoding)");
                        }
                    } else {
                        this.framePayloadLength = this.framePayloadLen1;
                    }
                    if (this.framePayloadLength > (long)this.maxFramePayloadLength) {
                        throw this.protocolViolation(WebSocketCloseStatus.MESSAGE_TOO_BIG, "Max frame length of " + this.maxFramePayloadLength + " has been exceeded.");
                    }
                    logger.trace("Decoding a WebSocket Frame. length: {}", (Object)this.framePayloadLength);
                    this.state = State.MASKING_KEY;
                }
                case 3: {
                    if (this.frameMasked) {
                        if (in.readableBytes() < 4) {
                            return;
                        }
                        this.mask = in.readInt();
                    }
                    this.state = State.PAYLOAD;
                }
                case 4: {
                    WebSocketFrame decodedFrame;
                    if ((long)in.readableBytes() < this.framePayloadLength) {
                        return;
                    }
                    ByteBuf payloadBuffer = Unpooled.EMPTY_BUFFER;
                    if (this.framePayloadLength > 0L) {
                        payloadBuffer = in.readBytes(WebSocketFrameDecoder.toFrameLength(this.framePayloadLength));
                    }
                    this.state = State.READING_FIRST;
                    if (this.frameMasked & this.framePayloadLength > 0L) {
                        this.unmask(payloadBuffer);
                    }
                    if (this.frameOpcode == WebSocketFrameType.PING.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledPing(payloadBuffer);
                        out.add(decodedFrame);
                        logger.trace("{} is decoded.", (Object)decodedFrame);
                        continue block7;
                    }
                    assert (payloadBuffer != null);
                    if (this.frameOpcode == WebSocketFrameType.PONG.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledPong(payloadBuffer);
                        out.add(decodedFrame);
                        logger.trace("{} is decoded.", (Object)decodedFrame);
                        continue block7;
                    }
                    if (this.frameOpcode == WebSocketFrameType.CLOSE.opcode()) {
                        this.receivedClosingHandshake = true;
                        this.validateCloseFrame(payloadBuffer);
                        decodedFrame = WebSocketFrame.ofPooledClose(payloadBuffer);
                        out.add(decodedFrame);
                        logger.trace("{} is decoded.", (Object)decodedFrame);
                        this.onCloseFrameRead();
                        continue block7;
                    }
                    if (this.frameOpcode != WebSocketFrameType.TEXT.opcode() && this.frameOpcode != WebSocketFrameType.BINARY.opcode() && this.frameOpcode != WebSocketFrameType.CONTINUATION.opcode()) {
                        throw this.protocolViolation(WebSocketCloseStatus.INVALID_MESSAGE_TYPE, "Cannot decode a web socket frame with opcode: " + this.frameOpcode);
                    }
                    if (this.frameOpcode == WebSocketFrameType.TEXT.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledText(payloadBuffer, this.finalFragment);
                    } else if (this.frameOpcode == WebSocketFrameType.BINARY.opcode()) {
                        decodedFrame = WebSocketFrame.ofPooledBinary(payloadBuffer, this.finalFragment);
                    } else {
                        assert (this.frameOpcode == WebSocketFrameType.CONTINUATION.opcode());
                        decodedFrame = WebSocketFrame.ofPooledContinuation(payloadBuffer, this.finalFragment);
                    }
                    logger.trace("{} is decoded.", (Object)decodedFrame);
                    if (this.finalFragment) {
                        this.fragmentedFramesCount = 0;
                        this.aggregatingFramesLength = 0L;
                        if (this.aggregatingFrames.isEmpty()) {
                            out.add(decodedFrame);
                            continue block7;
                        }
                        this.aggregatingFrames.add(decodedFrame);
                        ByteBuf[] byteBufs = (ByteBuf[])this.aggregatingFrames.stream().map(Bytes::byteBuf).toArray(ByteBuf[]::new);
                        if (this.aggregatingFrames.get(0).type() == WebSocketFrameType.TEXT) {
                            out.add(WebSocketFrame.ofPooledText(Unpooled.wrappedBuffer(byteBufs), true));
                        } else {
                            out.add(WebSocketFrame.ofPooledBinary(Unpooled.wrappedBuffer(byteBufs), true));
                        }
                        this.aggregatingFrames.clear();
                        continue block7;
                    }
                    ++this.fragmentedFramesCount;
                    if (this.aggregateContinuation) {
                        this.aggregatingFramesLength += this.framePayloadLength;
                        this.aggregatingFrames.add(decodedFrame);
                        if (this.aggregatingFramesLength <= (long)this.maxFramePayloadLength) continue block7;
                        throw this.protocolViolation(WebSocketCloseStatus.MESSAGE_TOO_BIG, "The length of aggregated frames exceeded the max frame length.  aggregated length: " + this.aggregatingFramesLength + ", max frame length: " + this.maxFramePayloadLength);
                    }
                    out.add(decodedFrame);
                    continue block7;
                }
            }
            throw new Error("Shouldn't reach here.");
        }
    }

    protected abstract boolean expectMaskedFrames();

    protected abstract void onCloseFrameRead();

    private void unmask(ByteBuf frame) {
        int i;
        long longMask = (long)this.mask & 0xFFFFFFFFL;
        longMask |= longMask << 32;
        int end = frame.writerIndex();
        int lim = end - 7;
        for (i = frame.readerIndex(); i < lim; i += 8) {
            frame.setLong(i, frame.getLong(i) ^ longMask);
        }
        if (i < end - 3) {
            frame.setInt(i, frame.getInt(i) ^ (int)longMask);
            i += 4;
        }
        int maskOffset = 0;
        while (i < end) {
            frame.setByte(i, frame.getByte(i) ^ WebSocketUtil.byteAtIndex(this.mask, maskOffset++ & 3));
            ++i;
        }
    }

    private WebSocketProtocolViolationException protocolViolation(String message) {
        return this.protocolViolation(WebSocketCloseStatus.PROTOCOL_ERROR, message);
    }

    private WebSocketProtocolViolationException protocolViolation(WebSocketCloseStatus status, String message) {
        this.state = State.CORRUPT;
        return new WebSocketProtocolViolationException(status, message);
    }

    private static int toFrameLength(long l) {
        return (int)l;
    }

    private void validateCloseFrame(ByteBuf buffer) {
        block6: {
            try {
                if (buffer.readableBytes() < 2) {
                    throw this.protocolViolation(WebSocketCloseStatus.INVALID_PAYLOAD_DATA, "Invalid close frame body");
                }
                short statusCode = buffer.getShort(buffer.readerIndex());
                if (!WebSocketCloseStatus.isValidStatusCode(statusCode)) {
                    throw this.protocolViolation("Invalid close frame status code: " + statusCode);
                }
                if (buffer.readableBytes() <= 2) break block6;
                try {
                    new Utf8Validator().check(buffer, buffer.readerIndex() + 2, buffer.readableBytes() - 2);
                }
                catch (IllegalArgumentException ex) {
                    throw this.protocolViolation(WebSocketCloseStatus.INVALID_PAYLOAD_DATA, "bytes are not UTF-8");
                }
            }
            catch (Exception e) {
                buffer.release();
                throw e;
            }
        }
    }

    @Override
    public void processOnComplete(StreamDecoderInput in, StreamDecoderOutput<WebSocketFrame> out) throws Exception {
        this.cleanup();
    }

    @Override
    public void processOnError(Throwable cause) {
        this.cleanup();
        if (!this.receivedClosingHandshake && this.outboundFrames != null) {
            this.outboundFrames.abort(cause);
        }
        this.onProcessOnError(cause);
    }

    protected void onProcessOnError(Throwable cause) {
    }

    private void cleanup() {
        if (!this.aggregatingFrames.isEmpty()) {
            for (WebSocketFrame frame : this.aggregatingFrames) {
                frame.close();
            }
            this.aggregatingFrames.clear();
        }
    }

    static enum State {
        READING_FIRST,
        READING_SECOND,
        READING_SIZE,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

