/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common.encoding;

import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.Unpooled;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.handler.codec.compression.SnappyFrameEncoder;
import java.io.IOException;
import java.io.OutputStream;

final class SnappyFramedOutputStream
extends OutputStream {
    private final SimpleSnappyFrameEncoder encoder = new SimpleSnappyFrameEncoder();
    private final ByteBuf out;

    SnappyFramedOutputStream(ByteBuf out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuf input = Unpooled.wrappedBuffer(b, off, len);
        try {
            this.encoder.encode(input, this.out);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failed to compress input with Snappy framing format:", e);
        }
    }

    private static class SimpleSnappyFrameEncoder
    extends SnappyFrameEncoder {
        private SimpleSnappyFrameEncoder() {
        }

        public void encode(ByteBuf in, ByteBuf out) throws Exception {
            this.encode((ChannelHandlerContext)null, in, out);
        }
    }
}

