/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.client.ClientTlsConfig;
import io.opentelemetry.testing.internal.armeria.common.AbstractTlsConfig;
import io.opentelemetry.testing.internal.armeria.common.TlsKeyPair;
import io.opentelemetry.testing.internal.armeria.common.TlsProvider;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.metric.CloseableMeterBinder;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.metric.MoreMeterBinders;
import io.opentelemetry.testing.internal.armeria.common.util.TlsEngineType;
import io.opentelemetry.testing.internal.armeria.internal.common.IgnoreHostsTrustManager;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock;
import io.opentelemetry.testing.internal.armeria.internal.common.util.SslContextUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableCollection;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.ServerTlsConfig;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContext;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContextBuilder;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslProvider;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SslContextFactory {
    private static final MeterIdPrefix SERVER_METER_ID_PREFIX = new MeterIdPrefix("armeria.server", "hostname.pattern", "UNKNOWN");
    private static final MeterIdPrefix CLIENT_METER_ID_PREFIX = new MeterIdPrefix("armeria.client");
    private final Map<CacheKey, SslContextHolder> cache = new HashMap<CacheKey, SslContextHolder>();
    private final Map<SslContext, CacheKey> reverseCache = new HashMap<SslContext, CacheKey>();
    private final TlsProvider tlsProvider;
    private final TlsEngineType engineType;
    private final MeterRegistry meterRegistry;
    @Nullable
    private final AbstractTlsConfig tlsConfig;
    @Nullable
    private final MeterIdPrefix meterIdPrefix;
    private final boolean allowsUnsafeCiphers;
    private final ReentrantShortLock lock = new ReentrantShortLock();

    public SslContextFactory(TlsProvider tlsProvider, TlsEngineType engineType, @Nullable AbstractTlsConfig tlsConfig, MeterRegistry meterRegistry) {
        assert (engineType.sslProvider() != SslProvider.OPENSSL_REFCNT);
        this.tlsProvider = tlsProvider;
        this.engineType = engineType;
        this.meterRegistry = meterRegistry;
        if (tlsConfig != null) {
            this.tlsConfig = tlsConfig;
            this.meterIdPrefix = tlsConfig.meterIdPrefix();
            this.allowsUnsafeCiphers = tlsConfig.allowsUnsafeCiphers();
        } else {
            this.tlsConfig = null;
            this.meterIdPrefix = null;
            this.allowsUnsafeCiphers = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SslContext getOrCreate(SslContextMode mode, String hostname) {
        this.lock.lock();
        try {
            TlsKeyPair tlsKeyPair = this.findTlsKeyPair(mode, hostname);
            List<X509Certificate> trustedCertificates = this.findTrustedCertificates(hostname);
            CacheKey cacheKey = new CacheKey(mode, tlsKeyPair, trustedCertificates);
            SslContextHolder contextHolder = this.cache.computeIfAbsent(cacheKey, this::create);
            contextHolder.retain();
            this.reverseCache.putIfAbsent(contextHolder.sslContext(), cacheKey);
            SslContext sslContext = contextHolder.sslContext();
            return sslContext;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(SslContext sslContext) {
        this.lock.lock();
        try {
            CacheKey cacheKey = this.reverseCache.get(sslContext);
            SslContextHolder contextHolder = this.cache.get(cacheKey);
            assert (contextHolder != null) : "sslContext not found in the cache: " + sslContext;
            if (contextHolder.release()) {
                SslContextHolder removed = this.cache.remove(cacheKey);
                assert (removed == contextHolder);
                this.reverseCache.remove(sslContext);
                contextHolder.destroy();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    private TlsKeyPair findTlsKeyPair(SslContextMode mode, String hostname) {
        TlsKeyPair tlsKeyPair = this.tlsProvider.keyPair(hostname);
        if (tlsKeyPair == null) {
            tlsKeyPair = this.tlsProvider.keyPair("*");
        }
        if (mode == SslContextMode.SERVER && tlsKeyPair == null) {
            throw new IllegalStateException("No TLS key pair found for " + hostname);
        }
        return tlsKeyPair;
    }

    private List<X509Certificate> findTrustedCertificates(String hostname) {
        List<X509Certificate> certs = this.tlsProvider.trustedCertificates(hostname);
        if (certs == null) {
            certs = this.tlsProvider.trustedCertificates("*");
        }
        return MoreObjects.firstNonNull(certs, ImmutableList.of());
    }

    private SslContextHolder create(CacheKey key) {
        MeterIdPrefix meterIdPrefix = this.meterIdPrefix(key.mode);
        SslContext sslContext = this.newSslContext(key);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (key.tlsKeyPair != null) {
            builder.addAll(key.tlsKeyPair.certificateChain());
        }
        if (!key.trustedCertificates.isEmpty()) {
            builder.addAll((Iterable)key.trustedCertificates);
        }
        ImmutableCollection certs = builder.build();
        CloseableMeterBinder meterBinder = null;
        if (!certs.isEmpty()) {
            meterBinder = MoreMeterBinders.certificateMetrics(certs, meterIdPrefix);
            meterBinder.bindTo(this.meterRegistry);
        }
        return new SslContextHolder(sslContext, meterBinder);
    }

    private SslContext newSslContext(CacheKey key) {
        SslContextMode mode = key.mode();
        TlsKeyPair tlsKeyPair = key.tlsKeyPair();
        List<X509Certificate> trustedCerts = key.trustedCertificates();
        if (mode == SslContextMode.SERVER) {
            assert (tlsKeyPair != null);
            return SslContextUtil.createSslContext(() -> {
                SslContextBuilder contextBuilder = SslContextBuilder.forServer(tlsKeyPair.privateKey(), tlsKeyPair.certificateChain());
                if (!trustedCerts.isEmpty()) {
                    contextBuilder.trustManager(trustedCerts);
                }
                this.applyTlsConfig(contextBuilder);
                return contextBuilder;
            }, false, this.engineType, this.allowsUnsafeCiphers, null, null);
        }
        boolean forceHttp1 = mode == SslContextMode.CLIENT_HTTP1_ONLY;
        return SslContextUtil.createSslContext(() -> {
            SslContextBuilder contextBuilder = SslContextBuilder.forClient();
            contextBuilder.endpointIdentificationAlgorithm("HTTPS");
            if (tlsKeyPair != null) {
                contextBuilder.keyManager(tlsKeyPair.privateKey(), tlsKeyPair.certificateChain());
            }
            if (!trustedCerts.isEmpty()) {
                contextBuilder.trustManager(trustedCerts);
            }
            this.applyTlsConfig(contextBuilder);
            return contextBuilder;
        }, forceHttp1, this.engineType, this.allowsUnsafeCiphers, null, null);
    }

    private void applyTlsConfig(SslContextBuilder contextBuilder) {
        if (this.tlsConfig == null) {
            return;
        }
        if (this.tlsConfig instanceof ServerTlsConfig) {
            ServerTlsConfig serverTlsConfig = (ServerTlsConfig)this.tlsConfig;
            contextBuilder.clientAuth(serverTlsConfig.clientAuth());
        } else {
            ClientTlsConfig clientTlsConfig = (ClientTlsConfig)this.tlsConfig;
            if (clientTlsConfig.tlsNoVerifySet()) {
                contextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else if (!clientTlsConfig.insecureHosts().isEmpty()) {
                contextBuilder.trustManager(IgnoreHostsTrustManager.of(clientTlsConfig.insecureHosts()));
            }
        }
        this.tlsConfig.tlsCustomizer().accept(contextBuilder);
    }

    private MeterIdPrefix meterIdPrefix(SslContextMode mode) {
        MeterIdPrefix meterIdPrefix = this.meterIdPrefix;
        if (meterIdPrefix == null) {
            meterIdPrefix = mode == SslContextMode.SERVER ? SERVER_METER_ID_PREFIX : CLIENT_METER_ID_PREFIX;
        }
        return meterIdPrefix;
    }

    public int numCachedContexts() {
        return this.cache.size();
    }

    public static enum SslContextMode {
        SERVER,
        CLIENT_HTTP1_ONLY,
        CLIENT;

    }

    private static final class CacheKey {
        private final SslContextMode mode;
        @Nullable
        private final TlsKeyPair tlsKeyPair;
        private final List<X509Certificate> trustedCertificates;

        private CacheKey(SslContextMode mode, @Nullable TlsKeyPair tlsKeyPair, List<X509Certificate> trustedCertificates) {
            this.mode = mode;
            this.tlsKeyPair = tlsKeyPair;
            this.trustedCertificates = trustedCertificates;
        }

        SslContextMode mode() {
            return this.mode;
        }

        @Nullable
        TlsKeyPair tlsKeyPair() {
            return this.tlsKeyPair;
        }

        public List<X509Certificate> trustedCertificates() {
            return this.trustedCertificates;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return this.mode == that.mode && Objects.equals(this.tlsKeyPair, that.tlsKeyPair) && this.trustedCertificates.equals(that.trustedCertificates);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mode, this.tlsKeyPair, this.trustedCertificates});
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("mode", (Object)this.mode).add("tlsKeyPair", this.tlsKeyPair).add("trustedCertificates", this.trustedCertificates).toString();
        }
    }

    private static final class SslContextHolder {
        private final SslContext sslContext;
        @Nullable
        private final CloseableMeterBinder meterBinder;
        private long refCnt;

        SslContextHolder(SslContext sslContext, @Nullable CloseableMeterBinder meterBinder) {
            this.sslContext = sslContext;
            this.meterBinder = meterBinder;
        }

        SslContext sslContext() {
            return this.sslContext;
        }

        void retain() {
            ++this.refCnt;
        }

        boolean release() {
            --this.refCnt;
            assert (this.refCnt >= 0L) : "refCount: " + this.refCnt;
            return this.refCnt == 0L;
        }

        void destroy() {
            if (this.meterBinder != null) {
                this.meterBinder.close();
            }
        }
    }
}

