/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.common;

import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.Http1HeaderNaming;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.RequestTarget;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Version;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttp2Headers;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import io.opentelemetry.testing.internal.armeria.internal.shaded.caffeine.cache.Caffeine;
import io.opentelemetry.testing.internal.armeria.internal.shaded.caffeine.cache.LoadingCache;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Ascii;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Joiner;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Splitter;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.server.ServerConfig;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.unix.DomainSocketAddress;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DefaultHeaders;
import io.opentelemetry.testing.internal.io.netty.handler.codec.UnsupportedValueConverter;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.EmptyHttpHeaders;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaderValues;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpRequest;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpResponseStatus;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpUtil;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpVersion;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.Http2Headers;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http2.HttpConversionUtil;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.io.netty.util.ByteProcessor;
import io.opentelemetry.testing.internal.io.netty.util.HashingStrategy;
import io.opentelemetry.testing.internal.io.netty.util.internal.StringUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public final class ArmeriaHttpUtil {
    private static final HashingStrategy<AsciiString> HTTP2_HEADER_NAME_HASHER = new HashingStrategy<AsciiString>(){

        @Override
        public int hashCode(AsciiString o) {
            return o.hashCode();
        }

        @Override
        public boolean equals(AsciiString a, AsciiString b) {
            return a.contentEqualsIgnoreCase(b);
        }
    };
    public static final Charset HTTP_DEFAULT_CONTENT_CHARSET = StandardCharsets.UTF_8;
    public static final AsciiString HEADER_NAME_PROXY_CONNECTION = AsciiString.cached("proxy-connection");
    private static final CaseInsensitiveMap HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST = new CaseInsensitiveMap();
    private static final CaseInsensitiveMap HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST = new CaseInsensitiveMap();
    private static final CaseInsensitiveMap HTTP_TRAILER_DISALLOWED_LIST = new CaseInsensitiveMap();
    static final Set<AsciiString> ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST;
    private static final Set<AsciiString> REQUEST_PSEUDO_HEADERS;
    private static final Set<AsciiString> PSEUDO_HEADERS;
    public static final String SERVER_HEADER;
    private static final CaseInsensitiveMap REQUEST_HEADER_TRANSLATIONS;
    private static final Splitter COOKIE_SPLITTER;
    private static final String COOKIE_SEPARATOR = "; ";
    private static final Joiner COOKIE_JOINER;
    @Nullable
    private static final LoadingCache<AsciiString, String> HEADER_VALUE_CACHE;
    private static final Set<AsciiString> CACHED_HEADERS;
    private static final Pattern SCHEME_PATTERN;

    private static LoadingCache<AsciiString, String> buildCache(String spec) {
        return Caffeine.from(spec).build(AsciiString::toString);
    }

    public static String schemeValidateAndNormalize(String scheme) {
        boolean isValidScheme = SCHEME_PATTERN.matcher(scheme).matches();
        if (isValidScheme) {
            return Ascii.toLowerCase(scheme);
        }
        throw new IllegalArgumentException("scheme: " + scheme + " (expected: a valid scheme)");
    }

    public static int findAuthority(String reqTarget) {
        int firstColonIdx = reqTarget.indexOf(58);
        if (firstColonIdx <= 0 || reqTarget.length() <= firstColonIdx + 3) {
            return -1;
        }
        int firstSlashIdx = reqTarget.indexOf(47);
        if (firstSlashIdx <= 0 || firstSlashIdx < firstColonIdx) {
            return -1;
        }
        if (reqTarget.charAt(firstColonIdx + 1) == '/' && reqTarget.charAt(firstColonIdx + 2) == '/') {
            return firstColonIdx + 3;
        }
        return -1;
    }

    public static String concatPaths(String prefix, @Nullable String path) {
        Objects.requireNonNull(prefix, "prefix");
        Preconditions.checkArgument(!prefix.isEmpty() && prefix.charAt(0) == '/', "prefix: %s (expected: an absolute path starting with '/')", (Object)prefix);
        path = MoreObjects.firstNonNull(path, "");
        if (path.isEmpty()) {
            return prefix;
        }
        if (prefix.length() == 1) {
            if (path.charAt(0) == '/') {
                return path;
            }
            return ArmeriaHttpUtil.simpleConcat("/", path);
        }
        return ArmeriaHttpUtil.slowConcatPaths(prefix, path);
    }

    private static String slowConcatPaths(String prefix, String path) {
        if (prefix.charAt(prefix.length() - 1) == '/') {
            if (path.charAt(0) == '/') {
                try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
                    String string = tmp.stringBuilder().append(prefix).append(path, 1, path.length()).toString();
                    return string;
                }
            }
            return ArmeriaHttpUtil.simpleConcat(prefix, path);
        }
        if (path.charAt(0) == '/' || path.charAt(0) == '?') {
            return ArmeriaHttpUtil.simpleConcat(prefix, path);
        }
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            String string = tmp.stringBuilder().append(prefix).append('/').append(path).toString();
            return string;
        }
    }

    private static String simpleConcat(String prefix, String path) {
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            String string = tmp.stringBuilder().append(prefix).append(path).toString();
            return string;
        }
    }

    public static String decodePath(String path) {
        if (path.indexOf(37) < 0) {
            return path;
        }
        return ArmeriaHttpUtil.slowDecodePath(path, false);
    }

    public static String decodePathParam(String pathParam) {
        if (pathParam.indexOf(37) < 0) {
            return pathParam;
        }
        return ArmeriaHttpUtil.slowDecodePath(pathParam, true);
    }

    private static String slowDecodePath(String path, boolean decodeSlash) {
        int len = path.length();
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            byte[] buf = tempThreadLocals.byteArray(len);
            int dstLen = 0;
            for (int i = 0; i < len; ++i) {
                int ch = path.charAt(i);
                if (ch != 37) {
                    buf[dstLen++] = (byte)((ch & 0xFF80) == 0 ? ch : 255);
                    continue;
                }
                int hexEnd = i + 3;
                if (hexEnd > len) {
                    buf[dstLen++] = -1;
                    break;
                }
                int digit1 = StringUtil.decodeHexNibble(path.charAt(++i));
                int digit2 = StringUtil.decodeHexNibble(path.charAt(++i));
                if (digit1 < 0 || digit2 < 0) {
                    buf[dstLen++] = -1;
                    continue;
                }
                byte decoded = (byte)(digit1 << 4 | digit2);
                if (decodeSlash || decoded != 47) {
                    buf[dstLen++] = decoded;
                    continue;
                }
                buf[dstLen++] = 37;
                buf[dstLen++] = 50;
                buf[dstLen++] = (byte)path.charAt(i);
            }
            String string = new String(buf, 0, dstLen, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static boolean isAbsoluteUri(@Nullable String maybeUri) {
        if (maybeUri == null) {
            return false;
        }
        int firstColonIdx = maybeUri.indexOf(58);
        if (firstColonIdx <= 0 || firstColonIdx + 3 >= maybeUri.length()) {
            return false;
        }
        int firstSlashIdx = maybeUri.indexOf(47);
        if (firstSlashIdx <= 0 || firstSlashIdx < firstColonIdx) {
            return false;
        }
        return maybeUri.charAt(firstColonIdx + 1) == '/' && maybeUri.charAt(firstColonIdx + 2) == '/';
    }

    public static boolean isInformational(@Nullable String statusText) {
        return statusText != null && !statusText.isEmpty() && statusText.charAt(0) == '1';
    }

    public static boolean isCorsPreflightRequest(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return headers.method() == HttpMethod.OPTIONS && headers.contains(HttpHeaderNames.ORIGIN) && headers.contains(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    }

    static Set<AsciiString> disallowedResponseHeaderNames() {
        return REQUEST_PSEUDO_HEADERS;
    }

    public static void parseDirectives(String directives, BiConsumer<String, String> callback) {
        int len = directives.length();
        int i = 0;
        while (i < len) {
            String value;
            char ch;
            int nameStart = i;
            while (i < len && (ch = directives.charAt(i)) != ',' && ch != '=') {
                ++i;
            }
            String name = directives.substring(nameStart, i).trim();
            if (i == len || directives.charAt(i) == ',') {
                ++i;
                value = null;
            } else {
                int valueStart;
                ++i;
                while (i < len && ((ch = directives.charAt(i)) == ' ' || ch == '\t')) {
                    ++i;
                }
                if (i < len && directives.charAt(i) == '\"') {
                    valueStart = ++i;
                    while (i < len && directives.charAt(i) != '\"') {
                        ++i;
                    }
                    value = directives.substring(valueStart, i);
                    ++i;
                    while (i < len) {
                        if (directives.charAt(i) == ',') {
                            ++i;
                            break;
                        }
                        ++i;
                    }
                } else {
                    valueStart = i;
                    while (i < len && directives.charAt(i) != ',') {
                        ++i;
                    }
                    value = directives.substring(valueStart, i).trim();
                    ++i;
                }
            }
            if (name.isEmpty()) continue;
            callback.accept(Ascii.toLowerCase(name), Strings.emptyToNull(value));
        }
    }

    public static long parseDirectiveValueAsSeconds(@Nullable String value) {
        if (value == null) {
            return -1L;
        }
        try {
            long converted = Long.parseLong(value);
            return converted >= 0L ? converted : -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static RequestHeaders toArmeriaRequestHeaders(ChannelHandlerContext ctx, Http2Headers headers, boolean endOfStream, String scheme, ServerConfig cfg, RequestTarget reqTarget) {
        assert (headers instanceof ArmeriaHttp2Headers);
        HttpHeadersBuilder builder = ((ArmeriaHttp2Headers)headers).delegate();
        builder.endOfStream(endOfStream);
        if (!builder.contains(HttpHeaderNames.CONTENT_LENGTH)) {
            builder.contentLengthUnknown();
        }
        if (!builder.contains(HttpHeaderNames.SCHEME)) {
            builder.add((CharSequence)HttpHeaderNames.SCHEME, scheme);
        }
        if (builder.get(HttpHeaderNames.AUTHORITY) == null && builder.get(HttpHeaderNames.HOST) == null) {
            builder.add((CharSequence)HttpHeaderNames.AUTHORITY, ArmeriaHttpUtil.defaultAuthority(ctx, cfg));
        }
        builder.set((CharSequence)HttpHeaderNames.PATH, reqTarget.toString());
        List<String> cookies = builder.getAll(HttpHeaderNames.COOKIE);
        if (cookies.size() > 1) {
            builder.set((CharSequence)HttpHeaderNames.COOKIE, COOKIE_JOINER.join(cookies));
        }
        return RequestHeaders.of(builder.build());
    }

    private static String defaultAuthority(ChannelHandlerContext ctx, ServerConfig cfg) {
        String defaultHostname = cfg.defaultVirtualHost().defaultHostname();
        SocketAddress localAddr = ctx.channel().localAddress();
        if (localAddr instanceof InetSocketAddress) {
            return defaultHostname + ':' + ((InetSocketAddress)localAddr).getPort();
        }
        assert (localAddr instanceof DomainSocketAddress) : localAddr;
        return defaultHostname;
    }

    public static HttpHeaders toArmeria(Http2Headers http2Headers, boolean request, boolean endOfStream) {
        assert (http2Headers instanceof ArmeriaHttp2Headers);
        HttpHeadersBuilder delegate = ((ArmeriaHttp2Headers)http2Headers).delegate();
        delegate.endOfStream(endOfStream);
        ArmeriaHttpUtil.maybeSetContentLengthUnknown(delegate.contains(HttpHeaderNames.CONTENT_LENGTH), delegate);
        HttpHeaders headers = delegate.build();
        if (request) {
            if (headers.contains(HttpHeaderNames.METHOD)) {
                headers = RequestHeaders.of(headers);
            }
        } else if (headers.contains(HttpHeaderNames.STATUS)) {
            headers = ResponseHeaders.of(headers);
        }
        return headers;
    }

    public static RequestHeaders toArmeria(ChannelHandlerContext ctx, HttpRequest in, RequestHeadersBuilder out, ServerConfig cfg, String scheme, RequestTarget reqTarget) throws URISyntaxException {
        io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders = in.headers();
        out.method(MoreObjects.firstNonNull(HttpMethod.tryParse(in.method().name()), HttpMethod.UNKNOWN)).scheme(scheme).path(reqTarget.toString());
        if (!out.contains(HttpHeaderNames.HOST)) {
            out.add((CharSequence)HttpHeaderNames.HOST, ArmeriaHttpUtil.defaultAuthority(ctx, cfg));
        }
        ArmeriaHttpUtil.purgeHttp1OnlyHeaders(inHeaders, out);
        return out.build();
    }

    public static ResponseHeaders toArmeria(HttpResponse in) {
        io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders = in.headers();
        ResponseHeadersBuilder out = ResponseHeaders.builder();
        out.sizeHint(inHeaders.size());
        out.status(HttpStatus.valueOf(in.status().code()));
        ArmeriaHttpUtil.toArmeria(inHeaders, out);
        return out.build();
    }

    public static HttpHeaders toArmeria(io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders) {
        if (inHeaders.isEmpty()) {
            return HttpHeaders.of();
        }
        HttpHeadersBuilder out = HttpHeaders.builder();
        out.sizeHint(inHeaders.size());
        ArmeriaHttpUtil.toArmeria(inHeaders, out);
        return out.build();
    }

    public static void toArmeria(io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders, HttpHeadersBuilder out) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iter2 = inHeaders.iteratorCharSequence();
        CaseInsensitiveMap connectionDisallowedList = ArmeriaHttpUtil.toLowercaseMap(inHeaders.valueCharSequenceIterator(HttpHeaderNames.CONNECTION), 8);
        StringJoiner cookieJoiner = null;
        while (iter2.hasNext()) {
            CharSequence value;
            Map.Entry<CharSequence, CharSequence> entry = iter2.next();
            AsciiString aName = HttpHeaderNames.of(entry.getKey()).toLowerCase();
            if ((HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.contains(aName) || connectionDisallowedList.contains(aName)) && !ArmeriaHttpUtil.maybeWebSocketUpgrade(aName, value = entry.getValue())) continue;
            if (aName.equals(HttpHeaderNames.TE)) {
                ArmeriaHttpUtil.toHttp2HeadersFilterTE(entry, out);
                continue;
            }
            value = entry.getValue();
            if (aName.equals(HttpHeaderNames.COOKIE)) {
                if (cookieJoiner == null) {
                    cookieJoiner = new StringJoiner(COOKIE_SEPARATOR);
                }
                COOKIE_SPLITTER.split(value).forEach(cookieJoiner::add);
                continue;
            }
            out.add((CharSequence)aName, ArmeriaHttpUtil.convertHeaderValue(aName, value));
        }
        if (cookieJoiner != null && cookieJoiner.length() != 0) {
            out.add((CharSequence)HttpHeaderNames.COOKIE, cookieJoiner.toString());
        }
        ArmeriaHttpUtil.maybeSetContentLengthUnknown(inHeaders.contains(HttpHeaderNames.CONTENT_LENGTH), out);
    }

    private static void purgeHttp1OnlyHeaders(io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders, HttpHeadersBuilder out) {
        ArmeriaHttpUtil.maybeSetTeHeader(inHeaders, out);
        ArmeriaHttpUtil.maybeRemoveConnectionHeaders(inHeaders, out);
        ArmeriaHttpUtil.maybeSetCookie(inHeaders, out);
        ArmeriaHttpUtil.maybeSetContentLengthUnknown(inHeaders.contains(HttpHeaderNames.CONTENT_LENGTH), out);
    }

    private static void maybeRemoveConnectionHeaders(io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders, HttpHeadersBuilder out) {
        CaseInsensitiveMap connectionDisallowedList = ArmeriaHttpUtil.toLowercaseMap(inHeaders.valueCharSequenceIterator(HttpHeaderNames.CONNECTION), 8);
        boolean isWebSocketUpgrade = ArmeriaHttpUtil.isWebSocketUpgrade(inHeaders);
        connectionDisallowedList.forEach(entry -> out.remove((CharSequence)entry.getKey()));
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.forEach(entry -> out.remove((CharSequence)entry.getKey()));
        if (isWebSocketUpgrade) {
            out.set((CharSequence)HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE.toString());
            out.set((CharSequence)HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET.toString());
        }
    }

    private static void maybeSetCookie(io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders, HttpHeadersBuilder out) {
        if (out.contains(HttpHeaderNames.COOKIE)) {
            StringJoiner cookieJoiner = new StringJoiner(COOKIE_SEPARATOR);
            inHeaders.getAll(HttpHeaderNames.COOKIE).forEach(value -> COOKIE_SPLITTER.split((CharSequence)value).forEach(cookieJoiner::add));
            out.set((CharSequence)HttpHeaderNames.COOKIE, cookieJoiner.toString());
        }
    }

    private static void maybeSetTeHeader(io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders, HttpHeadersBuilder out) {
        if (!inHeaders.contains(HttpHeaderNames.TE)) {
            return;
        }
        boolean hasTrailersTe = ArmeriaHttpUtil.findDelimitedIgnoreCase(HttpHeaderNames.TE, HttpHeaderValues.TRAILERS, inHeaders);
        if (hasTrailersTe) {
            out.set((CharSequence)HttpHeaderNames.TE, HttpHeaderValues.TRAILERS.toString());
        } else {
            out.remove(HttpHeaderNames.TE);
        }
    }

    private static boolean isWebSocketUpgrade(io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders inHeaders) {
        boolean isUpgrade = ArmeriaHttpUtil.findDelimitedIgnoreCase(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, inHeaders);
        boolean isWebsocket = ArmeriaHttpUtil.findDelimitedIgnoreCase(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET, inHeaders);
        return isUpgrade && isWebsocket;
    }

    private static boolean findDelimitedIgnoreCase(AsciiString targetName, AsciiString targetValue, io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders httpHeaders) {
        List<String> allValues = httpHeaders.getAll(targetName);
        if (allValues.isEmpty()) {
            return false;
        }
        for (String value : allValues) {
            if (targetValue.contentEqualsIgnoreCase(value)) {
                return true;
            }
            List<CharSequence> values = StringUtil.unescapeCsvFields(value);
            for (CharSequence field : values) {
                if (!targetValue.contentEqualsIgnoreCase(AsciiString.trim(field))) continue;
                return true;
            }
        }
        return false;
    }

    private static void maybeSetContentLengthUnknown(boolean hasContentLength, HttpHeadersBuilder out) {
        boolean isContentAlwaysEmpty;
        if (hasContentLength) {
            return;
        }
        HttpMethod method = null;
        if (out instanceof RequestHeadersBuilder) {
            method = ((RequestHeadersBuilder)out).method();
        }
        if (!(isContentAlwaysEmpty = method != null ? ArmeriaHttpUtil.isContentAlwaysEmpty(method) : false)) {
            out.contentLengthUnknown();
        }
    }

    private static boolean isContentAlwaysEmpty(HttpMethod method) {
        switch (method) {
            case CONNECT: 
            case GET: 
            case HEAD: 
            case OPTIONS: 
            case TRACE: {
                return true;
            }
        }
        return false;
    }

    private static boolean maybeWebSocketUpgrade(AsciiString header, CharSequence value) {
        if (HttpHeaderNames.CONNECTION.contentEqualsIgnoreCase(header) && HttpHeaderValues.UPGRADE.contentEqualsIgnoreCase(value)) {
            return true;
        }
        return HttpHeaderNames.UPGRADE.contentEqualsIgnoreCase(header) && HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(value);
    }

    private static CaseInsensitiveMap toLowercaseMap(Iterator<? extends CharSequence> valuesIter, int arraySizeHint) {
        CaseInsensitiveMap result = new CaseInsensitiveMap(arraySizeHint);
        while (valuesIter.hasNext()) {
            AsciiString lowerCased = AsciiString.of(valuesIter.next()).toLowerCase();
            try {
                int index = lowerCased.forEachByte(ByteProcessor.FIND_COMMA);
                if (index != -1) {
                    int start = 0;
                    do {
                        result.add(lowerCased.subSequence(start, index, false).trim(), AsciiString.EMPTY_STRING);
                    } while ((start = index + 1) < lowerCased.length() && (index = lowerCased.forEachByte(start, lowerCased.length() - start, ByteProcessor.FIND_COMMA)) != -1);
                    result.add(lowerCased.subSequence(start, lowerCased.length(), false).trim(), AsciiString.EMPTY_STRING);
                    continue;
                }
                result.add(lowerCased.trim(), AsciiString.EMPTY_STRING);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    private static void toHttp2HeadersFilterTE(Map.Entry<CharSequence, CharSequence> entry, HttpHeadersBuilder out) {
        block2: {
            block1: {
                if (AsciiString.indexOf(entry.getValue(), ',', 0) != -1) break block1;
                if (!AsciiString.contentEqualsIgnoreCase(AsciiString.trim(entry.getValue()), HttpHeaderValues.TRAILERS)) break block2;
                out.add((CharSequence)HttpHeaderNames.TE, HttpHeaderValues.TRAILERS.toString());
                break block2;
            }
            List<CharSequence> teValues = StringUtil.unescapeCsvFields(entry.getValue());
            for (CharSequence teValue : teValues) {
                if (!AsciiString.contentEqualsIgnoreCase(AsciiString.trim(teValue), HttpHeaderValues.TRAILERS)) continue;
                out.add((CharSequence)HttpHeaderNames.TE, HttpHeaderValues.TRAILERS.toString());
                break;
            }
        }
    }

    public static Http2Headers toNettyHttp2ServerHeaders(HttpHeadersBuilder inputHeaders) {
        for (Map.Entry entry : HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST) {
            inputHeaders.remove((CharSequence)entry.getKey());
        }
        for (AsciiString asciiString : ArmeriaHttpUtil.disallowedResponseHeaderNames()) {
            inputHeaders.remove(asciiString);
        }
        return new ArmeriaHttp2Headers(inputHeaders);
    }

    public static Http2Headers toNettyHttp2ServerTrailers(HttpHeaders inputHeaders) {
        HttpHeadersBuilder builder = inputHeaders.toBuilder();
        for (Map.Entry entry : HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST) {
            builder.remove((CharSequence)entry.getKey());
        }
        for (AsciiString asciiString : PSEUDO_HEADERS) {
            builder.remove(asciiString);
        }
        for (Map.Entry entry : HTTP_TRAILER_DISALLOWED_LIST) {
            builder.remove((CharSequence)entry.getKey());
        }
        return new ArmeriaHttp2Headers(builder);
    }

    public static Http2Headers toNettyHttp2ClientHeaders(HttpHeaders inputHeaders) {
        int headerSizeHint = inputHeaders.size() + 3;
        DefaultHttp2Headers outputHeaders = new DefaultHttp2Headers(false, headerSizeHint);
        ArmeriaHttpUtil.toNettyHttp2Client(inputHeaders, outputHeaders, false);
        return outputHeaders;
    }

    public static Http2Headers toNettyHttp2ClientTrailers(HttpHeaders inputHeaders) {
        int headerSizeHint = inputHeaders.size();
        DefaultHttp2Headers outputHeaders = new DefaultHttp2Headers(false, headerSizeHint);
        ArmeriaHttpUtil.toNettyHttp2Client(inputHeaders, outputHeaders, true);
        return outputHeaders;
    }

    private static void toNettyHttp2Client(HttpHeaders inputHeaders, Http2Headers outputHeaders, boolean isTrailer) {
        for (Map.Entry<AsciiString, String> entry : inputHeaders) {
            AsciiString name = entry.getKey();
            String value = entry.getValue();
            if (HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.contains(name) || isTrailer && ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            outputHeaders.add(name, value);
        }
        if (!outputHeaders.contains(HttpHeaderNames.COOKIE)) {
            return;
        }
        List cookies = outputHeaders.getAllAndRemove(HttpHeaderNames.COOKIE);
        for (CharSequence c : cookies) {
            outputHeaders.add(HttpHeaderNames.COOKIE, COOKIE_SPLITTER.split(c));
        }
    }

    public static void toNettyHttp1ServerHeaders(ResponseHeaders inputHeaders, io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming, boolean keepAlive) {
        ArmeriaHttpUtil.toNettyHttp1Server(inputHeaders, outputHeaders, http1HeaderNaming, false);
        HttpUtil.setKeepAlive(outputHeaders, HttpVersion.HTTP_1_1, keepAlive);
    }

    public static void toNettyHttp1ServerTrailers(HttpHeaders inputHeaders, io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming) {
        ArmeriaHttpUtil.toNettyHttp1Server(inputHeaders, outputHeaders, http1HeaderNaming, true);
    }

    public static void toNettyHttp1Server(HttpHeaders inputHeaders, io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming, boolean isTrailer) {
        for (Map.Entry<AsciiString, String> entry : inputHeaders) {
            AsciiString name = entry.getKey();
            String value = entry.getValue();
            if (HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.contains(name) || isTrailer && ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            outputHeaders.add(http1HeaderNaming.convert(name), (Object)value);
        }
    }

    public static io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders toNettyHttp1ClientHeaders(HttpHeaders inputHeaders) {
        if (inputHeaders.isEmpty()) {
            return EmptyHttpHeaders.INSTANCE;
        }
        DefaultHttpHeaders outputHeaders = new DefaultHttpHeaders(false);
        ArmeriaHttpUtil.toNettyHttp1Client(inputHeaders, outputHeaders, Http1HeaderNaming.ofDefault(), false);
        return outputHeaders;
    }

    public static void toNettyHttp1ClientHeaders(HttpHeaders inputHeaders, io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming) {
        ArmeriaHttpUtil.toNettyHttp1Client(inputHeaders, outputHeaders, http1HeaderNaming, false);
    }

    public static void toNettyHttp1ClientTrailers(HttpHeaders inputHeaders, io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming) {
        ArmeriaHttpUtil.toNettyHttp1Client(inputHeaders, outputHeaders, http1HeaderNaming, true);
    }

    private static void toNettyHttp1Client(HttpHeaders inputHeaders, io.opentelemetry.testing.internal.io.netty.handler.codec.http.HttpHeaders outputHeaders, Http1HeaderNaming http1HeaderNaming, boolean isTrailer) {
        StringJoiner cookieJoiner = null;
        for (Map.Entry<AsciiString, String> entry : inputHeaders) {
            AsciiString name = entry.getKey();
            String value = entry.getValue();
            AsciiString translatedName = REQUEST_HEADER_TRANSLATIONS.get(name);
            if (translatedName != null && !inputHeaders.contains(translatedName)) {
                outputHeaders.add((CharSequence)translatedName, (Object)value);
                continue;
            }
            if (HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.contains(name) || isTrailer && ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            if (HttpHeaderNames.COOKIE.equals(name)) {
                if (cookieJoiner == null) {
                    cookieJoiner = new StringJoiner(COOKIE_SEPARATOR);
                }
                COOKIE_SPLITTER.split(value).forEach(cookieJoiner::add);
                continue;
            }
            outputHeaders.add(http1HeaderNaming.convert(name), (Object)value);
        }
        if (cookieJoiner != null && cookieJoiner.length() != 0) {
            outputHeaders.add((CharSequence)HttpHeaderNames.COOKIE, (Object)cookieJoiner.toString());
        }
    }

    public static ResponseHeaders maybeUpdateContentLengthAndEndOfStream(ResponseHeaders headers, HttpData content, HttpHeaders trailers, boolean isAggregatedResponse) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        HttpStatus status = headers.status();
        if (status.isContentAlwaysEmpty()) {
            if (status != HttpStatus.NOT_MODIFIED && headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                return headers.toBuilder().removeAndThen(HttpHeaderNames.CONTENT_LENGTH).endOfStream(true).build();
            }
            return ArmeriaHttpUtil.maybeSetEndOfStream(headers, 0, isAggregatedResponse);
        }
        if (!trailers.isEmpty()) {
            if (headers.contains(HttpHeaderNames.CONTENT_LENGTH)) {
                ResponseHeadersBuilder builder = headers.toBuilder();
                builder.remove(HttpHeaderNames.CONTENT_LENGTH);
                return builder.build();
            }
            return headers;
        }
        long contentLength = headers.isContentLengthUnknown() ? -1L : (headers.contentLength() > 0L && content.isEmpty() ? headers.contentLength() : (long)content.length());
        if (contentLength >= 0L) {
            return headers.toBuilder().contentLength(contentLength).removeAndThen(HttpHeaderNames.TRANSFER_ENCODING).build();
        }
        return ArmeriaHttpUtil.maybeSetEndOfStream(headers, content.length(), isAggregatedResponse);
    }

    private static ResponseHeaders maybeSetEndOfStream(ResponseHeaders headers, int contentLength, boolean isAggregatedResponse) {
        if (contentLength > 0) {
            return headers;
        }
        if (isAggregatedResponse) {
            return headers;
        }
        if (headers.isEndOfStream()) {
            return headers;
        }
        return headers.toBuilder().endOfStream(true).build();
    }

    public static String convertHeaderValue(AsciiString name, CharSequence value) {
        if (!(value instanceof AsciiString)) {
            return value.toString();
        }
        if (HEADER_VALUE_CACHE != null && CACHED_HEADERS.contains(name)) {
            String converted = HEADER_VALUE_CACHE.get((AsciiString)value);
            assert (converted != null);
            return converted;
        }
        return value.toString();
    }

    public static boolean isTrailerDisallowed(AsciiString name) {
        return HTTP_TRAILER_DISALLOWED_LIST.contains(name);
    }

    public static String authorityHeader(String host, int port, int defaultPort) {
        if (port == defaultPort) {
            return host;
        }
        StringBuilder buf = new StringBuilder(host.length() + 6);
        buf.append(host);
        buf.append(':');
        buf.append(port);
        return buf.toString();
    }

    public static boolean isRequestTimeoutResponse(HttpResponse httpResponse) {
        return httpResponse.status().code() == HttpResponseStatus.REQUEST_TIMEOUT.code() && "close".equalsIgnoreCase(httpResponse.headers().get(HttpHeaderNames.CONNECTION));
    }

    public static <T> void toHttp1Headers(HttpHeaders armeriaHeaders, T output, TriConsumer<T, AsciiString, String> writer) {
        for (Map.Entry<AsciiString, String> e : armeriaHeaders) {
            AsciiString k = e.getKey();
            String v = e.getValue();
            if (k.charAt(0) != ':') {
                writer.accept(output, k, v);
                continue;
            }
            if (!HttpHeaderNames.AUTHORITY.equals(k) || armeriaHeaders.contains(HttpHeaderNames.HOST)) continue;
            writer.accept(output, HttpHeaderNames.HOST, v);
        }
    }

    private ArmeriaHttpUtil() {
    }

    static {
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.CONNECTION, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.KEEP_ALIVE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HEADER_NAME_PROXY_CONNECTION, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.UPGRADE, AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP_TO_HTTP2_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.AUTHORITY, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.METHOD, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.PATH, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.SCHEME, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.STATUS, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), AsciiString.EMPTY_STRING);
        HTTP2_TO_HTTP_HEADER_DISALLOWED_LIST.add(HttpConversionUtil.ExtensionHeaderNames.PATH.text(), AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.TRANSFER_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CONTENT_LENGTH, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CACHE_CONTROL, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.EXPECT, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.HOST, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.MAX_FORWARDS, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.PRAGMA, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.RANGE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.TE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.WWW_AUTHENTICATE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.AUTHORIZATION, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.PROXY_AUTHENTICATE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.PROXY_AUTHORIZATION, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.DATE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.LOCATION, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.RETRY_AFTER, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.VARY, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.WARNING, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CONTENT_ENCODING, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CONTENT_TYPE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.CONTENT_RANGE, AsciiString.EMPTY_STRING);
        HTTP_TRAILER_DISALLOWED_LIST.add(HttpHeaderNames.TRAILER, AsciiString.EMPTY_STRING);
        ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST = ImmutableSet.of(HttpHeaderNames.SCHEME, HttpHeaderNames.STATUS, HttpHeaderNames.METHOD);
        REQUEST_PSEUDO_HEADERS = ImmutableSet.of(HttpHeaderNames.METHOD, HttpHeaderNames.SCHEME, HttpHeaderNames.AUTHORITY, HttpHeaderNames.PATH, HttpHeaderNames.PROTOCOL);
        PSEUDO_HEADERS = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(REQUEST_PSEUDO_HEADERS)).add(HttpHeaderNames.STATUS)).build();
        SERVER_HEADER = "Armeria/" + Version.get("armeria", ArmeriaHttpUtil.class.getClassLoader()).artifactVersion();
        REQUEST_HEADER_TRANSLATIONS = new CaseInsensitiveMap();
        REQUEST_HEADER_TRANSLATIONS.add(Http2Headers.PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
        COOKIE_SPLITTER = Splitter.on(';').trimResults().omitEmptyStrings();
        COOKIE_JOINER = Joiner.on(COOKIE_SEPARATOR);
        HEADER_VALUE_CACHE = Flags.headerValueCacheSpec() != null ? ArmeriaHttpUtil.buildCache(Flags.headerValueCacheSpec()) : null;
        CACHED_HEADERS = Flags.cachedHeaders().stream().map(AsciiString::of).collect(ImmutableSet.toImmutableSet());
        SCHEME_PATTERN = Pattern.compile("^([a-zA-Z][a-zA-Z0-9+\\-.]*)");
    }

    private static final class CaseInsensitiveMap
    extends DefaultHeaders<AsciiString, AsciiString, CaseInsensitiveMap> {
        CaseInsensitiveMap() {
            super(HTTP2_HEADER_NAME_HASHER, UnsupportedValueConverter.instance());
        }

        CaseInsensitiveMap(int size) {
            super(HTTP2_HEADER_NAME_HASHER, UnsupportedValueConverter.instance(), DefaultHeaders.NameValidator.NOT_NULL, size);
        }

        @Override
        @Nullable
        public AsciiString get(AsciiString name) {
            return (AsciiString)super.get(name);
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

