/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client.dns;

import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

final class DnsQuestionContext {
    private final long queryTimeoutMillis;
    private final CompletableFuture<Void> whenCancelled = new CompletableFuture();
    private final ScheduledFuture<?> scheduledFuture;
    private boolean complete;

    DnsQuestionContext(EventExecutor executor, long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
        this.scheduledFuture = executor.schedule(() -> this.whenCancelled.cancel(true), queryTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    CompletableFuture<Void> whenCancelled() {
        return this.whenCancelled;
    }

    boolean isCancelled() {
        return this.whenCancelled.isCompletedExceptionally();
    }

    void cancelScheduler() {
        if (!this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(false);
        }
    }

    void setComplete() {
        this.complete = true;
        this.cancelScheduler();
    }

    boolean isCompleted() {
        return this.complete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DnsQuestionContext)) {
            return false;
        }
        DnsQuestionContext that = (DnsQuestionContext)o;
        return this.queryTimeoutMillis == that.queryTimeoutMillis && this.complete == that.complete && this.whenCancelled.equals(that.whenCancelled) && this.scheduledFuture.equals(that.scheduledFuture);
    }

    public int hashCode() {
        int result = this.whenCancelled.hashCode();
        result = 31 * result + this.scheduledFuture.hashCode();
        result = 31 * result + (int)this.queryTimeoutMillis;
        result = 31 * result + (this.complete ? 1 : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("queryTimeoutMillis", this.queryTimeoutMillis).add("whenCancelled", this.whenCancelled).add("scheduledFuture", this.scheduledFuture).toString();
    }
}

