/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.internal.client;

import io.opentelemetry.testing.internal.armeria.client.ClientPreprocessors;
import io.opentelemetry.testing.internal.armeria.client.Clients;
import io.opentelemetry.testing.internal.armeria.client.HttpPreprocessor;
import io.opentelemetry.testing.internal.armeria.client.Preprocessor;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import java.net.URI;
import java.util.Objects;

public final class ClientBuilderParamsUtil {
    private static final String INTERNAL_PREFIX = "armeria-";
    private static final String PREPROCESSOR_PREFIX = "armeria-preprocessor-";
    public static final String ENDPOINT_GROUP_PREFIX = "armeria-group-";
    public static final String UNDEFINED_URI_AUTHORITY = "armeria-undefined:1";

    public static URI preprocessorToUri(HttpPreprocessor preprocessor, @Nullable String absolutePathRef) {
        return ClientBuilderParamsUtil.preprocessorToUri(Scheme.of(SerializationFormat.NONE, SessionProtocol.HTTP), preprocessor, absolutePathRef);
    }

    public static URI preprocessorToUri(Scheme scheme, ClientPreprocessors preprocessors, @Nullable String absolutePathRef) {
        return ClientBuilderParamsUtil.preprocessorToUri(scheme, ClientBuilderParamsUtil.generateHashCode(preprocessors), absolutePathRef);
    }

    public static URI preprocessorToUri(Scheme scheme, Preprocessor<?, ?> preprocessor, @Nullable String absolutePathRef) {
        return ClientBuilderParamsUtil.preprocessorToUri(scheme, ClientBuilderParamsUtil.generateHashCode(preprocessor), absolutePathRef);
    }

    private static URI preprocessorToUri(Scheme scheme, String hashCode, @Nullable String absolutePathRef) {
        String schemeStr = scheme.shortUriText();
        String normalizedAbsolutePathRef = ClientBuilderParamsUtil.nullOrEmptyToSlash(absolutePathRef);
        return URI.create(schemeStr + "://" + PREPROCESSOR_PREFIX + hashCode + ":1" + normalizedAbsolutePathRef);
    }

    static String generateHashCode(Object obj) {
        return Integer.toHexString(System.identityHashCode(Objects.requireNonNull(obj, "obj")));
    }

    public static String nullOrEmptyToSlash(@Nullable String absolutePathRef) {
        if (Strings.isNullOrEmpty(absolutePathRef)) {
            return "/";
        }
        Preconditions.checkArgument(absolutePathRef.charAt(0) == '/', "absolutePathRef: %s (must start with '/')", (Object)absolutePathRef);
        return absolutePathRef;
    }

    public static boolean isInternalUri(URI uri) {
        if (Clients.isUndefinedUri(uri)) {
            return true;
        }
        String authority = uri.getAuthority();
        return authority != null && authority.startsWith(INTERNAL_PREFIX) && uri.getPort() == 1;
    }

    public static boolean isPreprocessorUri(URI uri) {
        String authority = uri.getAuthority();
        return authority != null && authority.startsWith(PREPROCESSOR_PREFIX) && uri.getPort() == 1;
    }

    private ClientBuilderParamsUtil() {
    }
}

