/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.stream;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.SubscriptionOption;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.StreamMessageUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.math.IntMath;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.math.LongMath;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class AsyncMapStreamMessage<T, U>
implements StreamMessage<U> {
    private final StreamMessage<T> source;
    private final Function<T, CompletableFuture<U>> function;
    private final int maxConcurrency;

    AsyncMapStreamMessage(StreamMessage<? extends T> source, Function<? super T, ? extends CompletableFuture<? extends U>> function, int maxConcurrency) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(function, "function");
        this.source = source;
        this.function = function;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public boolean isOpen() {
        return this.source.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public long demand() {
        return this.source.demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.source.whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super U> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        this.source.subscribe(new AsyncMapSubscriber<T, U>(subscriber, this.function, executor, this.maxConcurrency), executor, options);
    }

    @Override
    public void abort() {
        this.source.abort();
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.source.abort(cause);
    }

    private static final class AsyncMapSubscriber<T, U>
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<? super U> downstream;
        private final Function<T, CompletableFuture<U>> function;
        private final EventExecutor executor;
        private final int maxConcurrency;
        @Nullable
        private volatile Subscription upstream;
        private volatile boolean canceled;
        private long requestedByDownstream;
        private int requestedFromUpstream;
        private int pendingFutures;
        private boolean completed;

        AsyncMapSubscriber(Subscriber<? super U> downstream, Function<T, CompletableFuture<U>> function, EventExecutor executor, int maxConcurrency) {
            Objects.requireNonNull(downstream, "downstream");
            Objects.requireNonNull(function, "function");
            Objects.requireNonNull(executor, "executor");
            this.downstream = downstream;
            this.function = function;
            this.executor = executor;
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            Objects.requireNonNull(item, "item");
            if (this.canceled) {
                StreamMessageUtil.closeOrAbort(item);
                return;
            }
            if (this.requestedFromUpstream != Integer.MAX_VALUE) {
                --this.requestedFromUpstream;
            }
            try {
                CompletableFuture<U> future = this.function.apply(item);
                Objects.requireNonNull(future, "function.apply() returned null");
                ++this.pendingFutures;
                future.handle((res, cause) -> {
                    if (this.executor.inEventLoop()) {
                        this.publishDownstream((U)res, (Throwable)cause);
                    } else {
                        this.executor.execute(() -> this.publishDownstream((U)res, (Throwable)cause));
                    }
                    return null;
                });
            }
            catch (Throwable ex) {
                StreamMessageUtil.closeOrAbort(item, ex);
                this.onError(ex);
                Subscription upstream = this.upstream;
                assert (upstream != null);
                upstream.cancel();
            }
        }

        private void publishDownstream(@Nullable U item, @Nullable Throwable cause) {
            if (this.canceled) {
                if (item != null) {
                    StreamMessageUtil.closeOrAbort(item);
                }
                return;
            }
            Subscription upstream = this.upstream;
            assert (upstream != null);
            try {
                if (cause != null) {
                    this.onError(cause);
                    upstream.cancel();
                } else {
                    Objects.requireNonNull(item, "function.apply()'s future completed with null");
                    this.downstream.onNext(item);
                    --this.pendingFutures;
                    if (this.completed && this.pendingFutures == 0) {
                        this.downstream.onComplete();
                        return;
                    }
                    if (this.requestedByDownstream > 0L) {
                        if (this.requestedByDownstream != Long.MAX_VALUE) {
                            --this.requestedByDownstream;
                        }
                        ++this.requestedFromUpstream;
                        upstream.request(1L);
                    }
                }
            }
            catch (Throwable ex) {
                if (item != null) {
                    StreamMessageUtil.closeOrAbort(item, ex);
                }
                this.onError(ex);
                upstream.cancel();
            }
        }

        @Override
        public void onError(Throwable cause) {
            Objects.requireNonNull(cause, "cause");
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            this.downstream.onError(cause);
        }

        @Override
        public void onComplete() {
            if (this.canceled) {
                return;
            }
            if (this.pendingFutures > 0) {
                this.completed = true;
            } else {
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.onError(new IllegalArgumentException("n: " + n + " (expected: > 0, see Reactive Streams specification rule 3.9)"));
                Subscription upstream = this.upstream;
                assert (upstream != null);
                upstream.cancel();
                return;
            }
            if (this.canceled) {
                return;
            }
            if (this.executor.inEventLoop()) {
                this.handleRequest(n);
            } else {
                this.executor.execute(() -> this.handleRequest(n));
            }
        }

        private void handleRequest(long n) {
            this.requestedByDownstream = LongMath.saturatedAdd(this.requestedByDownstream, n);
            if (this.maxConcurrency > IntMath.saturatedAdd(this.requestedFromUpstream, this.pendingFutures)) {
                int available = this.maxConcurrency - this.pendingFutures - this.requestedFromUpstream;
                long toRequest = Math.min(n, (long)available);
                if (this.requestedByDownstream != Long.MAX_VALUE) {
                    this.requestedByDownstream -= toRequest;
                }
                this.requestedFromUpstream = IntMath.saturatedAdd(this.requestedFromUpstream, (int)toRequest);
                Subscription upstream = this.upstream;
                assert (upstream != null);
                upstream.request(toRequest);
            }
        }

        @Override
        public void cancel() {
            if (this.canceled) {
                return;
            }
            this.canceled = true;
            Subscription upstream = this.upstream;
            assert (upstream != null);
            upstream.cancel();
        }
    }
}

