/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.outlier;

import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierDetectionDecision;
import io.opentelemetry.testing.internal.armeria.common.outlier.OutlierRule;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;

@UnstableApi
public final class OutlierDetectingRuleBuilder {
    static final OutlierRule DEFAULT_RULE = OutlierRule.builder().onServerError().onException().build();
    @Nullable
    private OutlierRule rules;

    OutlierDetectingRuleBuilder() {
    }

    public OutlierDetectingRuleBuilder onServerError() {
        return this.onResponseHeaders((ctx, headers) -> {
            if (headers.status().isServerError()) {
                return OutlierDetectionDecision.FAILURE;
            }
            return OutlierDetectionDecision.NEXT;
        });
    }

    public OutlierDetectingRuleBuilder onStatus(HttpStatus status) {
        return this.onStatus(status, OutlierDetectionDecision.FAILURE);
    }

    public OutlierDetectingRuleBuilder onStatus(HttpStatus status, OutlierDetectionDecision decision) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(decision, "decision");
        return this.onStatus(status::equals, decision);
    }

    public OutlierDetectingRuleBuilder onStatus(Predicate<? super HttpStatus> predicate, OutlierDetectionDecision decision) {
        Objects.requireNonNull(predicate, "predicate");
        Objects.requireNonNull(decision, "decision");
        return this.onResponseHeaders((ctx, headers) -> {
            if (predicate.test(headers.status())) {
                return decision;
            }
            return OutlierDetectionDecision.NEXT;
        });
    }

    public OutlierDetectingRuleBuilder onResponseHeaders(BiFunction<? super RequestContext, ? super ResponseHeaders, OutlierDetectionDecision> function) {
        Objects.requireNonNull(function, "function");
        OutlierRule rule = (ctx, headers, cause) -> {
            if (headers == null) {
                return OutlierDetectionDecision.NEXT;
            }
            return (OutlierDetectionDecision)((Object)((Object)function.apply(ctx, headers)));
        };
        this.addRule(rule);
        return this;
    }

    public OutlierDetectingRuleBuilder onException(BiFunction<? super RequestContext, ? super Throwable, OutlierDetectionDecision> function) {
        Objects.requireNonNull(function, "function");
        OutlierRule rule = (ctx, headers, cause) -> {
            if (cause == null) {
                return OutlierDetectionDecision.NEXT;
            }
            return (OutlierDetectionDecision)((Object)((Object)function.apply(ctx, cause)));
        };
        this.addRule(rule);
        return this;
    }

    public OutlierDetectingRuleBuilder onException() {
        return this.onException((? super RequestContext ctx, ? super Throwable cause) -> OutlierDetectionDecision.FAILURE);
    }

    public OutlierDetectingRuleBuilder onException(Class<? extends Throwable> exceptionType) {
        return this.onException(exceptionType, OutlierDetectionDecision.FAILURE);
    }

    public OutlierDetectingRuleBuilder onException(Class<? extends Throwable> exceptionType, OutlierDetectionDecision decision) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(decision, "decision");
        this.onException((? super RequestContext ctx, ? super Throwable cause) -> {
            if (exceptionType.isInstance(cause)) {
                return decision;
            }
            return OutlierDetectionDecision.NEXT;
        });
        return this;
    }

    private void addRule(OutlierRule newRule) {
        this.rules = this.rules == null ? newRule : this.rules.orElse(newRule);
    }

    public OutlierRule build() {
        Preconditions.checkState(this.rules != null, "No rule has been added.");
        return this.rules;
    }
}

