/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.JsonHeadersSanitizer;
import io.opentelemetry.testing.internal.armeria.common.logging.JsonHeadersSanitizerBuilder;
import io.opentelemetry.testing.internal.armeria.common.logging.TextHeadersSanitizer;
import io.opentelemetry.testing.internal.armeria.common.logging.TextHeadersSanitizerBuilder;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import java.util.function.BiFunction;

@FunctionalInterface
public interface HeadersSanitizer<T>
extends BiFunction<RequestContext, HttpHeaders, T> {
    public static HeadersSanitizer<String> ofText() {
        return TextHeadersSanitizer.INSTANCE;
    }

    public static TextHeadersSanitizerBuilder builderForText() {
        return new TextHeadersSanitizerBuilder();
    }

    public static HeadersSanitizer<JsonNode> ofJson() {
        return JsonHeadersSanitizer.INSTANCE;
    }

    public static JsonHeadersSanitizerBuilder builderForJson() {
        return new JsonHeadersSanitizerBuilder();
    }

    @Nullable
    public T sanitize(RequestContext var1, HttpHeaders var2);

    @Override
    @Nullable
    default public T apply(RequestContext requestContext, HttpHeaders entries) {
        return this.sanitize(requestContext, entries);
    }
}

