/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.BuiltInProperty;
import io.opentelemetry.testing.internal.armeria.common.logging.ExportGroup;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class ExportGroupBuilder {
    private static final String PREFIX_REQ_HEADERS = "req.headers.";
    private static final String PREFIX_RES_HEADERS = "res.headers.";
    private static final String PREFIX_ATTRS = "attrs.";
    private static final String ATTR_NAMESPACE = "attr:";
    @Nullable
    private String prefix;
    private final ImmutableSet.Builder<ExportEntry<BuiltInProperty>> builtIns = ImmutableSet.builder();
    private final ImmutableSet.Builder<ExportEntry<AttributeKey<?>>> attrs = ImmutableSet.builder();
    private final ImmutableSet.Builder<ExportEntry<AsciiString>> reqHeaders = ImmutableSet.builder();
    private final ImmutableSet.Builder<ExportEntry<AsciiString>> resHeaders = ImmutableSet.builder();

    ExportGroupBuilder() {
    }

    public ExportGroup build() {
        if (this.prefix == null) {
            return new ExportGroup((Set<ExportEntry<BuiltInProperty>>)((Object)this.builtIns.build()), (Set<ExportEntry<AttributeKey<?>>>)((Object)this.attrs.build()), (Set<ExportEntry<AsciiString>>)((Object)this.reqHeaders.build()), (Set<ExportEntry<AsciiString>>)((Object)this.resHeaders.build()));
        }
        return new ExportGroup(ExportEntry.withPrefix((Set)((Object)this.builtIns.build()), this.prefix), ExportEntry.withPrefix((Set)((Object)this.attrs.build()), this.prefix), ExportEntry.withPrefix((Set)((Object)this.reqHeaders.build()), this.prefix), ExportEntry.withPrefix((Set)((Object)this.resHeaders.build()), this.prefix));
    }

    public ExportGroupBuilder prefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        Preconditions.checkArgument(!prefix.isEmpty(), "prefix must not be empty");
        this.prefix = prefix;
        return this;
    }

    public ExportGroupBuilder builtIn(BuiltInProperty property, String alias) {
        Objects.requireNonNull(property, "BuiltInProperty");
        Objects.requireNonNull(alias, "alias");
        this.builtIns.add((Object)new ExportEntry<BuiltInProperty>(property, alias));
        return this;
    }

    public ExportGroupBuilder attr(String alias, AttributeKey<?> attrKey) {
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(attrKey, "attrKey");
        this.attrs.add((Object)new ExportEntry(attrKey, alias));
        return this;
    }

    public ExportGroupBuilder attr(String alias, AttributeKey<?> attrKey, Function<?, String> stringifier) {
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(attrKey, "attrKey");
        Objects.requireNonNull(stringifier, "stringifier");
        this.attrs.add((Object)new ExportEntry(attrKey, alias, stringifier));
        return this;
    }

    public ExportGroupBuilder requestHeader(CharSequence headerName) {
        Objects.requireNonNull(headerName, "headerName");
        AsciiString key = ExportGroupBuilder.toHeaderName(headerName);
        this.reqHeaders.add((Object)new ExportEntry<AsciiString>(key, PREFIX_REQ_HEADERS + key));
        return this;
    }

    public ExportGroupBuilder requestHeader(CharSequence headerName, String alias) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(alias, "alias");
        this.reqHeaders.add((Object)new ExportEntry<AsciiString>(ExportGroupBuilder.toHeaderName(headerName), alias));
        return this;
    }

    public ExportGroupBuilder responseHeader(CharSequence headerName) {
        Objects.requireNonNull(headerName, "headerName");
        AsciiString key = ExportGroupBuilder.toHeaderName(headerName);
        this.resHeaders.add((Object)new ExportEntry<AsciiString>(key, PREFIX_RES_HEADERS + key));
        return this;
    }

    public ExportGroupBuilder responseHeader(CharSequence headerName, String alias) {
        Objects.requireNonNull(headerName, "headerName");
        Objects.requireNonNull(alias, "alias");
        this.resHeaders.add((Object)new ExportEntry<AsciiString>(ExportGroupBuilder.toHeaderName(headerName), alias));
        return this;
    }

    public ExportGroupBuilder keyPattern(String keyPattern) {
        BuiltInProperty property;
        Objects.requireNonNull(keyPattern, "keyPattern");
        int exportKeyPos = keyPattern.indexOf(61);
        if (keyPattern.contains("*")) {
            if (exportKeyPos > 0) {
                throw new IllegalArgumentException("A custom export key is unsupported for the wildcard: " + keyPattern);
            }
            BuiltInProperty.findByKeyPattern(keyPattern).stream().map(prop -> new ExportEntry<BuiltInProperty>((BuiltInProperty)((Object)prop), prop.key)).forEach(this.builtIns::add);
            return this;
        }
        String exportKey = null;
        if (exportKeyPos > 0) {
            exportKey = keyPattern.substring(0, exportKeyPos);
            keyPattern = keyPattern.substring(exportKeyPos + 1);
        }
        if ((property = BuiltInProperty.findByKey(keyPattern)) != null) {
            this.builtIns.add((Object)new ExportEntry<BuiltInProperty>(property, exportKey != null ? exportKey : property.key));
            return this;
        }
        if (keyPattern.startsWith(PREFIX_ATTRS) || keyPattern.startsWith(ATTR_NAMESPACE)) {
            ExportEntry<AttributeKey<?>> attrExportEntry = this.parseAttrPattern(keyPattern, exportKey);
            this.attrs.add((Object)attrExportEntry);
            return this;
        }
        if (keyPattern.startsWith(PREFIX_REQ_HEADERS)) {
            if (exportKey == null) {
                this.requestHeader(keyPattern.substring(PREFIX_REQ_HEADERS.length()));
            } else {
                this.requestHeader(keyPattern.substring(PREFIX_REQ_HEADERS.length()), exportKey);
            }
            return this;
        }
        if (keyPattern.startsWith(PREFIX_RES_HEADERS)) {
            if (exportKey == null) {
                this.requestHeader(keyPattern.substring(PREFIX_RES_HEADERS.length()));
            } else {
                this.requestHeader(keyPattern.substring(PREFIX_RES_HEADERS.length()), exportKey);
            }
            return this;
        }
        throw new IllegalArgumentException("unknown key pattern: " + keyPattern);
    }

    private static AsciiString toHeaderName(CharSequence name) {
        return HttpHeaderNames.of(Objects.requireNonNull(name, "name").toString());
    }

    private ExportEntry<AttributeKey<?>> parseAttrPattern(String keyPattern, @Nullable String exportKey) {
        String[] components = keyPattern.split(":");
        if (components.length < 2 || components.length > 3) {
            if (exportKey == null) {
                throw new IllegalArgumentException("invalid attribute export: " + keyPattern + " (expected: attrs.<alias>:<AttributeKey.name>[:<FQCN of Function<?, String>>])");
            }
            throw new IllegalArgumentException("invalid attribute export: " + keyPattern + " (expected: <alias>=attr:<AttributeKey.name>[:<FQCN of Function<?, String>>])");
        }
        if (exportKey == null) {
            exportKey = components[0];
        }
        AttributeKey attributeKey = AttributeKey.valueOf(components[1]);
        if (components.length == 3) {
            return new ExportEntry(attributeKey, exportKey, this.newStringifier(keyPattern, components[2]));
        }
        return new ExportEntry(attributeKey, exportKey);
    }

    private Function<?, String> newStringifier(String keyPattern, String className) {
        Function stringifier;
        try {
            stringifier = (Function)Class.forName(className, true, this.getClass().getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to instantiate a stringifier function: " + keyPattern, e);
        }
        return stringifier;
    }

    static final class ExportEntry<T> {
        final T key;
        final String exportKey;
        @Nullable
        final Function<Object, String> stringifier;

        ExportEntry(T key, String exportKey) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(exportKey);
            this.key = key;
            this.exportKey = exportKey;
            this.stringifier = null;
        }

        ExportEntry(T key, String exportKey, Function<?, ?> stringifier) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(exportKey);
            Objects.requireNonNull(stringifier);
            this.key = key;
            this.exportKey = exportKey;
            this.stringifier = stringifier;
        }

        @Nullable
        String stringify(@Nullable Object value) {
            if (this.stringifier == null) {
                return value != null ? value.toString() : null;
            }
            return this.stringifier.apply(value);
        }

        public int hashCode() {
            return this.key.hashCode() * 31 + this.exportKey.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExportEntry)) {
                return false;
            }
            return this.key.equals(((ExportEntry)o).key) && this.exportKey.equals(((ExportEntry)o).exportKey);
        }

        public String toString() {
            return this.exportKey + ':' + this.key;
        }

        private ExportEntry<T> withPrefix(String exportPrefix) {
            Preconditions.checkArgument(!exportPrefix.isEmpty(), "exportPrefix must not be empty");
            if (this.stringifier == null) {
                return new ExportEntry<T>(this.key, exportPrefix + this.exportKey);
            }
            return new ExportEntry<T>(this.key, exportPrefix + this.exportKey, this.stringifier);
        }

        private static <T> Set<ExportEntry<T>> withPrefix(Set<ExportEntry<T>> entries, String exportPrefix) {
            Preconditions.checkArgument(!exportPrefix.isEmpty(), "exportPrefix must not be empty");
            return entries.stream().map(entry -> entry.withPrefix(exportPrefix)).collect(ImmutableSet.toImmutableSet());
        }
    }
}

