/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.loadbalancer;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.LoadBalancer;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.hash.Hashing;
import java.util.List;
import java.util.function.ToLongFunction;

final class StickyLoadBalancer<T, C>
implements LoadBalancer<T, C> {
    private final ToLongFunction<? super C> contextHasher;
    private final List<T> candidates;

    StickyLoadBalancer(Iterable<? extends T> candidates, ToLongFunction<? super C> contextHasher) {
        this.candidates = ImmutableList.copyOf(candidates);
        this.contextHasher = contextHasher;
    }

    @Override
    @Nullable
    public T pick(C context) {
        if (this.candidates.isEmpty()) {
            return null;
        }
        long key = this.contextHasher.applyAsLong(context);
        int nearest = Hashing.consistentHash(key, this.candidates.size());
        return this.candidates.get(nearest);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("contextHasher", this.contextHasher).add("candidates", this.candidates).toString();
    }
}

