/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common.auth;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.auth.AuthToken;
import io.opentelemetry.testing.internal.armeria.common.auth.AuthUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public final class BasicToken
extends AuthToken {
    private final String username;
    private final String password;
    @Nullable
    private String headerValue;

    @Deprecated
    public static BasicToken of(String username, String password) {
        return new BasicToken(username, password);
    }

    BasicToken(String username, String password) {
        this.username = Objects.requireNonNull(username, "username");
        this.password = Objects.requireNonNull(password, "password");
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    @Override
    public String asHeaderValue() {
        if (this.headerValue != null) {
            return this.headerValue;
        }
        this.headerValue = "Basic " + Base64.getEncoder().encodeToString((this.username + ':' + this.password).getBytes(StandardCharsets.UTF_8));
        return this.headerValue;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicToken)) {
            return false;
        }
        BasicToken that = (BasicToken)o;
        return AuthUtil.secureEquals(this.username, that.username) & AuthUtil.secureEquals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("username", this.username).add("password", "****").toString();
    }
}

