/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.CommonPools;
import io.opentelemetry.testing.internal.armeria.common.RefreshingTlsProvider;
import io.opentelemetry.testing.internal.armeria.common.TlsKeyPair;
import io.opentelemetry.testing.internal.armeria.common.TlsProviderBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;

@FunctionalInterface
@UnstableApi
public interface TlsProvider
extends AutoCloseable {
    public static TlsProvider of(TlsKeyPair tlsKeyPair) {
        Objects.requireNonNull(tlsKeyPair, "tlsKeyPair");
        return TlsProvider.builder().keyPair(tlsKeyPair).build();
    }

    public static TlsProvider ofScheduled(Supplier<TlsKeyPair> keyPairSupplier, Duration interval) {
        return TlsProvider.ofScheduled(keyPairSupplier, interval, CommonPools.blockingTaskExecutor());
    }

    public static TlsProvider ofScheduled(Supplier<TlsKeyPair> keyPairSupplier, Duration interval, ScheduledExecutorService executor) {
        return TlsProvider.ofScheduled(keyPairSupplier, ImmutableList.of(), null, interval, executor);
    }

    public static TlsProvider ofScheduled(Supplier<TlsKeyPair> keyPairSupplier, Iterable<? extends X509Certificate> certificates, @Nullable Consumer<TlsKeyPair> onKeyPairUpdated, Duration interval, ScheduledExecutorService executor) {
        Objects.requireNonNull(keyPairSupplier, "keyPairSupplier");
        Objects.requireNonNull(certificates, "certificates");
        Objects.requireNonNull(interval, "interval");
        Objects.requireNonNull(executor, "executor");
        if (interval.isNegative() || interval.isZero()) {
            throw new IllegalArgumentException("interval: " + interval + " (expected: > 0)");
        }
        return new RefreshingTlsProvider(keyPairSupplier, ImmutableList.copyOf(certificates), onKeyPairUpdated, interval, executor);
    }

    public static TlsProviderBuilder builder() {
        return new TlsProviderBuilder();
    }

    @Nullable
    public TlsKeyPair keyPair(String var1);

    @Nullable
    default public List<X509Certificate> trustedCertificates(String hostname) {
        return null;
    }

    default public boolean autoClose() {
        return true;
    }

    @Override
    default public void close() {
    }
}

