/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AbstractContextAwareExecutor;
import io.opentelemetry.testing.internal.armeria.common.AbstractContextAwareExecutorService;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;

final class PropagatingContextAwareExecutorService
extends AbstractContextAwareExecutorService<ExecutorService> {
    static PropagatingContextAwareExecutorService of(ExecutorService executor) {
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof PropagatingContextAwareExecutorService) {
            return (PropagatingContextAwareExecutorService)executor;
        }
        return new PropagatingContextAwareExecutorService(executor);
    }

    private PropagatingContextAwareExecutorService(ExecutorService executor) {
        super(executor);
    }

    @Override
    @Nullable
    RequestContext contextOrNull() {
        return RequestContext.mapCurrent(Function.identity(), AbstractContextAwareExecutor.LogRequestContextWarningOnce.INSTANCE);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("executor", this.withoutContext()).toString();
    }
}

