/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.AggregationOptions;
import io.opentelemetry.testing.internal.armeria.common.DefaultHttpRequestDuplicator;
import io.opentelemetry.testing.internal.armeria.common.FixedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpMessage;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestBuilder;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestDuplicator;
import io.opentelemetry.testing.internal.armeria.common.HttpRequestWriter;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.PublisherBasedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.RequestHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.SplitHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.StreamMessageBasedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamMessage;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamTimeoutMode;
import io.opentelemetry.testing.internal.armeria.internal.common.DefaultHttpRequest;
import io.opentelemetry.testing.internal.armeria.internal.common.DefaultSplitHttpRequest;
import io.opentelemetry.testing.internal.armeria.internal.common.HeaderOverridingHttpRequest;
import io.opentelemetry.testing.internal.armeria.internal.common.stream.SurroundingPublisher;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.errorprone.annotations.CheckReturnValue;
import io.opentelemetry.testing.internal.errorprone.annotations.FormatMethod;
import io.opentelemetry.testing.internal.errorprone.annotations.FormatString;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public interface HttpRequest
extends HttpMessage,
Request {
    public static HttpRequestWriter streaming(HttpMethod method, String path) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        return HttpRequest.streaming(RequestHeaders.of(method, path));
    }

    public static HttpRequestWriter streaming(RequestHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return new DefaultHttpRequest(headers);
    }

    public static HttpRequest of(HttpMethod method, String path) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        return HttpRequest.of(RequestHeaders.of(method, path));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, CharSequence content) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(mediaType, "mediaType");
        return HttpRequest.of(method, path, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), content));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, String content) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(mediaType, "mediaType");
        return HttpRequest.of(method, path, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), content));
    }

    @FormatMethod
    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, @FormatString String format, Object ... args) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        return HttpRequest.of(method, path, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), format, args));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, byte[] content) {
        Objects.requireNonNull(content, "content");
        return HttpRequest.of(method, path, mediaType, HttpData.wrap(content));
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, HttpData content) {
        return HttpRequest.of(method, path, mediaType, content, HttpHeaders.of());
    }

    public static HttpRequest of(HttpMethod method, String path, MediaType mediaType, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(method, "method");
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(mediaType, "mediaType");
        return HttpRequest.of(RequestHeaders.builder(method, path).contentType(mediaType).build(), content, trailers);
    }

    public static HttpRequest of(RequestHeaders headers) {
        return HttpRequest.of(headers, HttpData.empty());
    }

    public static HttpRequest of(RequestHeaders headers, HttpData content) {
        return HttpRequest.of(headers, content, HttpHeaders.of());
    }

    public static HttpRequest of(RequestHeaders headers, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        int contentLength = content.length();
        if (contentLength == 0) {
            content.close();
            headers = headers.toBuilder().removeAndThen(HttpHeaderNames.CONTENT_LENGTH).build();
            if (!trailers.isEmpty()) {
                return new FixedHttpRequest.OneElementFixedHttpRequest(headers, trailers);
            }
            return new FixedHttpRequest.EmptyFixedHttpRequest(headers);
        }
        headers = headers.toBuilder().contentLength(contentLength).build();
        if (trailers.isEmpty()) {
            return new FixedHttpRequest.OneElementFixedHttpRequest(headers, content);
        }
        return new FixedHttpRequest.TwoElementFixedHttpRequest(headers, content, trailers);
    }

    public static HttpRequest of(RequestHeaders headers, HttpData ... contents) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(contents, "contents");
        switch (contents.length) {
            case 0: {
                return new FixedHttpRequest.EmptyFixedHttpRequest(headers);
            }
            case 1: {
                return new FixedHttpRequest.OneElementFixedHttpRequest(headers, contents[0]);
            }
            case 2: {
                return new FixedHttpRequest.TwoElementFixedHttpRequest(headers, contents[0], contents[1]);
            }
        }
        return new FixedHttpRequest.RegularFixedHttpRequest(headers, contents);
    }

    public static HttpRequest of(RequestHeaders headers, Publisher<? extends HttpObject> publisher) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(publisher, "publisher");
        if (publisher instanceof HttpRequest) {
            return ((HttpRequest)publisher).withHeaders(headers);
        }
        if (publisher instanceof StreamMessage) {
            return new StreamMessageBasedHttpRequest(headers, (StreamMessage)publisher);
        }
        return new PublisherBasedHttpRequest(headers, publisher);
    }

    @UnstableApi
    public static HttpRequest of(RequestHeaders headers, Publisher<? extends HttpData> publisher, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(publisher, "publisher");
        Objects.requireNonNull(trailers, "trailers");
        if (trailers.isEmpty()) {
            return HttpRequest.of(headers, publisher);
        }
        return HttpRequest.of(headers, SurroundingPublisher.of(null, publisher, trailers));
    }

    @UnstableApi
    public static HttpRequest of(RequestHeaders headers, Publisher<? extends HttpData> publisher, CompletableFuture<HttpHeaders> trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(publisher, "publisher");
        Objects.requireNonNull(trailers, "trailers");
        return HttpRequest.of(headers, SurroundingPublisher.of(null, publisher, trailers));
    }

    @UnstableApi
    public static HttpRequest of(RequestHeaders headers, CompletionStage<? extends StreamMessage<? extends HttpObject>> stage) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(stage, "stage");
        return HttpRequest.of(headers, StreamMessage.of(stage));
    }

    @UnstableApi
    public static HttpRequest of(RequestHeaders headers, CompletionStage<? extends StreamMessage<? extends HttpObject>> stage, EventExecutor subscriberExecutor) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(stage, "stage");
        Objects.requireNonNull(subscriberExecutor, "subscriberExecutor");
        return HttpRequest.of(headers, StreamMessage.of(stage, subscriberExecutor));
    }

    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    public RequestHeaders headers();

    default public URI uri() {
        return this.headers().uri();
    }

    @Nullable
    default public String scheme() {
        return this.headers().scheme();
    }

    default public HttpMethod method() {
        return this.headers().method();
    }

    default public String path() {
        return this.headers().path();
    }

    @Nullable
    default public String authority() {
        return this.headers().authority();
    }

    @Nullable
    default public MediaType contentType() {
        return this.headers().contentType();
    }

    @Nullable
    default public List<Locale.LanguageRange> acceptLanguages() {
        return this.headers().acceptLanguages();
    }

    @Nullable
    default public Locale selectLocale(Iterable<Locale> supportedLocales) {
        return this.headers().selectLocale(supportedLocales);
    }

    @Nullable
    default public Locale selectLocale(Locale ... supportedLocales) {
        return this.selectLocale(ImmutableList.copyOf(Objects.requireNonNull(supportedLocales, "supportedLocales")));
    }

    default public HttpRequest withHeaders(RequestHeaders newHeaders) {
        Objects.requireNonNull(newHeaders, "newHeaders");
        if (this.headers() == newHeaders) {
            return this;
        }
        return HeaderOverridingHttpRequest.of(this, newHeaders);
    }

    default public HttpRequest withHeaders(RequestHeadersBuilder newHeadersBuilder) {
        Objects.requireNonNull(newHeadersBuilder, "newHeadersBuilder");
        return this.withHeaders(newHeadersBuilder.build());
    }

    @UnstableApi
    public CompletableFuture<AggregatedHttpRequest> aggregate(AggregationOptions var1);

    default public CompletableFuture<AggregatedHttpRequest> aggregate() {
        return this.aggregate(this.defaultSubscriberExecutor());
    }

    default public CompletableFuture<AggregatedHttpRequest> aggregate(EventExecutor executor) {
        Objects.requireNonNull(executor, "executor");
        return this.aggregate(AggregationOptions.builder().executor(executor).cacheResult(true).build());
    }

    @Deprecated
    @UnstableApi
    default public CompletableFuture<AggregatedHttpRequest> aggregateWithPooledObjects(ByteBufAllocator alloc) {
        return this.aggregateWithPooledObjects(this.defaultSubscriberExecutor(), alloc);
    }

    @Deprecated
    default public CompletableFuture<AggregatedHttpRequest> aggregateWithPooledObjects(EventExecutor executor, ByteBufAllocator alloc) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(alloc, "alloc");
        return this.aggregate(AggregationOptions.builder().executor(executor).usePooledObjects(alloc).build());
    }

    default public HttpRequestDuplicator toDuplicator() {
        return this.toDuplicator(Flags.defaultMaxRequestLength());
    }

    default public HttpRequestDuplicator toDuplicator(EventExecutor executor) {
        return this.toDuplicator(executor, Flags.defaultMaxRequestLength());
    }

    default public HttpRequestDuplicator toDuplicator(long maxRequestLength) {
        return this.toDuplicator(this.defaultSubscriberExecutor(), maxRequestLength);
    }

    default public HttpRequestDuplicator toDuplicator(EventExecutor executor, long maxRequestLength) {
        Objects.requireNonNull(executor, "executor");
        return new DefaultHttpRequestDuplicator(this, executor, maxRequestLength);
    }

    @CheckReturnValue
    default public SplitHttpRequest split() {
        return this.split(this.defaultSubscriberExecutor());
    }

    @CheckReturnValue
    default public SplitHttpRequest split(EventExecutor executor) {
        return new DefaultSplitHttpRequest(this, Objects.requireNonNull(executor, "executor"));
    }

    default public HttpRequest mapHeaders(Function<? super RequestHeaders, ? extends RequestHeaders> function) {
        Objects.requireNonNull(function, "function");
        RequestHeaders transformed = function.apply(this.headers());
        Objects.requireNonNull(transformed, "function.apply() returned null");
        return this.withHeaders(transformed);
    }

    @Override
    default public HttpRequest mapData(Function<? super HttpData, ? extends HttpData> function) {
        Objects.requireNonNull(function, "function");
        StreamMessage<HttpObject> stream = this.map(obj -> obj instanceof HttpData ? (HttpObject)function.apply((HttpData)obj) : obj);
        return HttpRequest.of(this.headers(), stream);
    }

    @Override
    default public HttpRequest mapTrailers(Function<? super HttpHeaders, ? extends HttpHeaders> function) {
        Objects.requireNonNull(function, "function");
        StreamMessage<HttpObject> stream = this.map(obj -> {
            if (obj instanceof HttpHeaders) {
                return (HttpObject)function.apply((HttpHeaders)obj);
            }
            return obj;
        });
        return HttpRequest.of(this.headers(), stream);
    }

    default public HttpRequest mapError(Function<? super Throwable, ? extends Throwable> function) {
        Objects.requireNonNull(function, "function");
        return HttpRequest.of(this.headers(), HttpMessage.super.mapError(function));
    }

    @Override
    @UnstableApi
    default public HttpRequest peekData(Consumer<? super HttpData> action) {
        Objects.requireNonNull(action, "action");
        StreamMessage stream = this.peek(action, HttpData.class);
        return HttpRequest.of(this.headers(), stream);
    }

    @Override
    @UnstableApi
    default public HttpRequest peekTrailers(Consumer<? super HttpHeaders> action) {
        Objects.requireNonNull(action, "action");
        StreamMessage stream = this.peek(action, HttpHeaders.class);
        return HttpRequest.of(this.headers(), stream);
    }

    @UnstableApi
    default public HttpRequest peekError(Consumer<? super Throwable> action) {
        Objects.requireNonNull(action, "action");
        return HttpRequest.of(this.headers(), HttpMessage.super.peekError(action));
    }

    default public HttpRequest subscribeOn(EventExecutor eventExecutor) {
        Objects.requireNonNull(eventExecutor, "eventExecutor");
        return HttpRequest.of(this.headers(), HttpMessage.super.subscribeOn(eventExecutor));
    }

    @UnstableApi
    default public HttpRequest timeout(Duration timeoutDuration) {
        return this.timeout(timeoutDuration, StreamTimeoutMode.UNTIL_NEXT);
    }

    @UnstableApi
    default public HttpRequest timeout(Duration timeoutDuration, StreamTimeoutMode timeoutMode) {
        return HttpRequest.of(this.headers(), HttpMessage.super.timeout(timeoutDuration, timeoutMode));
    }
}

