/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.util.Sampler;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.jctools.maps.NonBlockingHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

final class ExceptionSampler
implements Sampler<Class<? extends Throwable>> {
    private final Map<Class<? extends Throwable>, Sampler<Class<? extends Throwable>>> samplers = new NonBlockingHashMap<Class<? extends Throwable>, Sampler<Class<? extends Throwable>>>();
    private final Function<? super Class<? extends Throwable>, ? extends Sampler<Class<? extends Throwable>>> samplerFactory = unused -> Sampler.of(spec);
    private final String spec;

    ExceptionSampler(String spec) {
        this.spec = spec;
    }

    @Override
    public boolean isSampled(Class<? extends Throwable> exceptionType) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        return this.samplers.computeIfAbsent(exceptionType, this.samplerFactory).isSampled(exceptionType);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.spec).toString();
    }
}

