/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.DependencyInjector;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ReentrantShortLock;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultDependencyInjector
implements DependencyInjector {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDependencyInjector.class);
    private final Map<Class<?>, Object> singletons = new HashMap();
    private final Lock lock = new ReentrantShortLock();
    private boolean isShutdown;

    DefaultDependencyInjector(Iterable<Object> singletons) {
        Objects.requireNonNull(singletons, "singletons");
        for (Object singleton : singletons) {
            Objects.requireNonNull(singleton, "singleton");
            this.singletons.put(singleton.getClass(), singleton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getInstance(Class<T> type) {
        this.lock.lock();
        try {
            if (this.isShutdown) {
                throw new IllegalStateException("Already shut down");
            }
            Object instance = this.singletons.get(type);
            if (instance != null) {
                Object object = instance;
                return (T)object;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.isShutdown) {
                return;
            }
            this.isShutdown = true;
            for (Object instance : this.singletons.values()) {
                if (!(instance instanceof AutoCloseable)) continue;
                DefaultDependencyInjector.close((AutoCloseable)instance);
            }
            this.singletons.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            logger.warn("Unexpected exception while closing {}", (Object)closeable, (Object)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("singletons", this.singletons).toString();
    }
}

