/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareFunction;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.common.context.ArmeriaContextPropagation;
import io.opentelemetry.testing.internal.io.micrometer.context.ContextSnapshot;
import java.util.Objects;
import java.util.function.Function;

final class DefaultContextAwareFunction<T, R>
implements ContextAwareFunction<T, R> {
    private final RequestContext context;
    private final Function<T, R> function;
    private final ContextSnapshot contextSnapshot;

    DefaultContextAwareFunction(RequestContext context, Function<T, R> function) {
        this.context = Objects.requireNonNull(context, "context");
        this.function = Objects.requireNonNull(function, "function");
        this.contextSnapshot = ArmeriaContextPropagation.captureAll();
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Function<T, R> withoutContext() {
        return this.function;
    }

    @Override
    public R apply(T t) {
        try (SafeCloseable ignored = this.context.push();){
            R r;
            block12: {
                ContextSnapshot.Scope ignored2 = this.contextSnapshot.setThreadLocals();
                try {
                    r = this.function.apply(t);
                    if (ignored2 == null) break block12;
                    ignored2.close();
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            return r;
        }
    }
}

