/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.ContextAwareCallable;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.common.context.ArmeriaContextPropagation;
import io.opentelemetry.testing.internal.io.micrometer.context.ContextSnapshot;
import java.util.Objects;
import java.util.concurrent.Callable;

final class DefaultContextAwareCallable<T>
implements ContextAwareCallable<T> {
    private final RequestContext context;
    private final Callable<T> callable;
    private final ContextSnapshot contextSnapshot;

    DefaultContextAwareCallable(RequestContext context, Callable<T> callable) {
        this.context = Objects.requireNonNull(context, "context");
        this.callable = Objects.requireNonNull(callable, "callable");
        this.contextSnapshot = ArmeriaContextPropagation.captureAll();
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Callable<T> withoutContext() {
        return this.callable;
    }

    @Override
    public T call() throws Exception {
        try (SafeCloseable ignored = this.context.push();){
            T t;
            block12: {
                ContextSnapshot.Scope ignored2 = this.contextSnapshot.setThreadLocals();
                try {
                    t = this.callable.call();
                    if (ignored2 == null) break block12;
                    ignored2.close();
                }
                catch (Throwable throwable) {
                    if (ignored2 != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            return t;
        }
    }
}

