/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.Cookie;
import io.opentelemetry.testing.internal.armeria.common.CookieBuilder;
import io.opentelemetry.testing.internal.armeria.common.CookieUtil;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.io.netty.handler.codec.DateFormatter;
import io.opentelemetry.testing.internal.io.netty.handler.codec.http.cookie.CookieHeaderNames;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientCookieDecoder {
    private static final Logger logger = LoggerFactory.getLogger(ClientCookieDecoder.class);

    @Nullable
    static Cookie decode(boolean strict, String header) {
        char c;
        int headerLen = header.length();
        assert (headerLen != 0) : headerLen;
        CookieBuilder builder = null;
        int i = 0;
        while (i != headerLen && (c = header.charAt(i)) != ',') {
            int valueBegin;
            int valueEnd;
            int nameEnd;
            int nameBegin;
            block11: {
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ';') {
                    ++i;
                    continue;
                }
                nameBegin = i;
                do {
                    char curChar;
                    if ((curChar = header.charAt(i)) == ';') {
                        nameEnd = i;
                        valueEnd = -1;
                        valueBegin = -1;
                    } else {
                        if (curChar != '=') continue;
                        nameEnd = i++;
                        if (i == headerLen) {
                            valueEnd = 0;
                            valueBegin = 0;
                        } else {
                            valueBegin = i;
                            int semiPos = header.indexOf(59, i);
                            i = semiPos > 0 ? semiPos : headerLen;
                            valueEnd = i;
                        }
                    }
                    break block11;
                } while (++i != headerLen);
                nameEnd = headerLen;
                valueEnd = -1;
                valueBegin = -1;
            }
            if (valueEnd > 0 && header.charAt(valueEnd - 1) == ',') {
                --valueEnd;
            }
            if (builder == null) {
                builder = CookieUtil.initCookie(logger, strict, header, nameBegin, nameEnd, valueBegin, valueEnd);
                if (builder != null) continue;
                return null;
            }
            ClientCookieDecoder.appendAttribute(builder, header, nameBegin, nameEnd, valueBegin, valueEnd);
        }
        if (builder == null) {
            return null;
        }
        ClientCookieDecoder.mergeMaxAgeAndExpires(builder, header);
        return builder.build();
    }

    private static void appendAttribute(CookieBuilder builder, String header, int keyStart, int keyEnd, int valueStart, int valueEnd) {
        int length = keyEnd - keyStart;
        if (length == 4) {
            ClientCookieDecoder.parse4(builder, header, keyStart, valueStart, valueEnd);
        } else if (length == 6) {
            ClientCookieDecoder.parse6(builder, header, keyStart, valueStart, valueEnd);
        } else if (length == 7) {
            ClientCookieDecoder.parse7(builder, header, keyStart, valueStart, valueEnd);
        } else if (length == 8) {
            ClientCookieDecoder.parse8(builder, header, keyStart, valueStart, valueEnd);
        }
    }

    private static void parse4(CookieBuilder builder, String header, int nameStart, int valueStart, int valueEnd) {
        String path;
        if (header.regionMatches(true, nameStart, "Path", 0, 4) && (path = ClientCookieDecoder.computeValue(header, valueStart, valueEnd)) != null) {
            builder.path(path);
        }
    }

    private static void parse6(CookieBuilder builder, String header, int nameStart, int valueStart, int valueEnd) {
        if (header.regionMatches(true, nameStart, "Domain", 0, 5)) {
            String domain = ClientCookieDecoder.computeValue(header, valueStart, valueEnd);
            if (domain != null) {
                builder.domain(domain);
            }
        } else if (header.regionMatches(true, nameStart, "Secure", 0, 5)) {
            builder.secure(true);
        }
    }

    private static void setMaxAge(CookieBuilder builder, String value) {
        try {
            builder.maxAge(Math.max(Long.parseLong(value), 0L));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static void parse7(CookieBuilder builder, String header, int nameStart, int valueStart, int valueEnd) {
        String maxAge;
        if (header.regionMatches(true, nameStart, "Expires", 0, 7)) {
            builder.expiresStart = valueStart;
            builder.expiresEnd = valueEnd;
        } else if (header.regionMatches(true, nameStart, "Max-Age", 0, 7) && (maxAge = ClientCookieDecoder.computeValue(header, valueStart, valueEnd)) != null) {
            ClientCookieDecoder.setMaxAge(builder, maxAge);
        }
    }

    private static void parse8(CookieBuilder builder, String header, int nameStart, int valueStart, int valueEnd) {
        if (header.regionMatches(true, nameStart, "HTTPOnly", 0, 8)) {
            builder.httpOnly(true);
        } else if (header.regionMatches(true, nameStart, "SameSite", 0, 8)) {
            String sameSite = ClientCookieDecoder.computeValue(header, valueStart, valueEnd);
            builder.sameSite(ClientCookieDecoder.getValidSameSite(sameSite));
        }
    }

    private static boolean isValueDefined(int valueStart, int valueEnd) {
        return valueStart != -1 && valueStart != valueEnd;
    }

    @Nullable
    private static String computeValue(String header, int valueStart, int valueEnd) {
        return ClientCookieDecoder.isValueDefined(valueStart, valueEnd) ? header.substring(valueStart, valueEnd) : null;
    }

    private static void mergeMaxAgeAndExpires(CookieBuilder builder, String header) {
        Date expiresDate;
        if (builder.maxAge != Long.MIN_VALUE) {
            return;
        }
        if (ClientCookieDecoder.isValueDefined(builder.expiresStart, builder.expiresEnd) && (expiresDate = DateFormatter.parseHttpDate(header, builder.expiresStart, builder.expiresEnd)) != null) {
            long maxAgeMillis = expiresDate.getTime() - System.currentTimeMillis();
            builder.maxAge(maxAgeMillis / 1000L + (long)(maxAgeMillis % 1000L != 0L ? 1 : 0));
        }
    }

    private static String getValidSameSite(@Nullable String sameSite) {
        return Arrays.stream(CookieHeaderNames.SameSite.values()).map(Enum::name).filter(name -> name.equalsIgnoreCase(sameSite)).findFirst().orElse(CookieHeaderNames.SameSite.Lax.name());
    }

    private ClientCookieDecoder() {
    }
}

