/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.redirect;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.redirect.RedirectConfig;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.client.RedirectingClientUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

@UnstableApi
public final class RedirectConfigBuilder {
    private int maxRedirects = 19;
    @Nullable
    private Set<SessionProtocol> allowedProtocols;
    private boolean isAllowingAllDomains;
    @Nullable
    private Set<String> allowedDomains;
    @Nullable
    private BiPredicate<ClientRequestContext, String> predicate;

    RedirectConfigBuilder() {
    }

    public RedirectConfigBuilder maxRedirects(int maxRedirects) {
        Preconditions.checkArgument(maxRedirects > 0, "maxRedirects: %s (expected: > 0)", maxRedirects);
        this.maxRedirects = maxRedirects;
        return this;
    }

    public RedirectConfigBuilder allowProtocols(SessionProtocol ... protocols) {
        Objects.requireNonNull(protocols, "protocols");
        return this.allowProtocols(ImmutableSet.copyOf(protocols));
    }

    public RedirectConfigBuilder allowProtocols(Iterable<SessionProtocol> protocols) {
        Objects.requireNonNull(protocols, "protocols");
        for (SessionProtocol protocol : protocols) {
            if (protocol == SessionProtocol.HTTP || protocol == SessionProtocol.HTTPS) continue;
            throw new IllegalArgumentException("protocol: " + (Object)((Object)protocol) + " (expected: " + (Object)((Object)SessionProtocol.HTTP) + " or " + (Object)((Object)SessionProtocol.HTTPS) + ')');
        }
        this.allowedProtocols = ImmutableSet.copyOf(protocols);
        return this;
    }

    public RedirectConfigBuilder allowAllDomains() {
        this.isAllowingAllDomains = true;
        return this;
    }

    public RedirectConfigBuilder allowDomains(String ... domains) {
        return this.allowDomains(ImmutableList.copyOf(Objects.requireNonNull(domains, "domains")));
    }

    public RedirectConfigBuilder allowDomains(Iterable<String> domains) {
        Objects.requireNonNull(domains, "domains");
        if (this.allowedDomains == null) {
            this.allowedDomains = new HashSet<String>();
        }
        this.allowedDomains.addAll(ImmutableList.copyOf(domains));
        return this;
    }

    public RedirectConfigBuilder allowDomains(BiPredicate<? super ClientRequestContext, ? super String> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.predicate = this.predicate == null ? predicate : this.predicate.or(predicate);
        return this;
    }

    public RedirectConfig build() {
        BiPredicate<ClientRequestContext, String> predicate;
        if (this.isAllowingAllDomains) {
            predicate = RedirectingClientUtil.allowAllDomains;
        } else {
            BiPredicate<ClientRequestContext, String> allowedDomains = this.allowedDomains();
            if (allowedDomains != null) {
                predicate = allowedDomains;
                if (this.predicate != null) {
                    predicate = predicate.or(this.predicate);
                }
            } else {
                predicate = this.predicate;
            }
        }
        return new RedirectConfig(this.allowedProtocols, predicate, this.maxRedirects);
    }

    @Nullable
    private BiPredicate<ClientRequestContext, String> allowedDomains() {
        if (this.allowedDomains != null) {
            ImmutableSet<String> allowedDomains0 = ImmutableSet.copyOf(this.allowedDomains);
            return (ctx, domain) -> {
                for (String d : allowedDomains0) {
                    if (!domain.equals(d)) continue;
                    return true;
                }
                return false;
            };
        }
        return null;
    }
}

