/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.CompositeEndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.client.endpoint.OrElseEndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.AsyncCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.Listenable;
import io.opentelemetry.testing.internal.armeria.internal.client.endpoint.StaticEndpointGroup;
import io.opentelemetry.testing.internal.armeria.internal.client.endpoint.UndefinedEndpointGroup;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface EndpointGroup
extends EndpointSelector,
AsyncCloseable,
Listenable<List<Endpoint>> {
    public static EndpointGroup of() {
        return StaticEndpointGroup.EMPTY;
    }

    public static EndpointGroup of(EndpointGroup ... endpointGroups) {
        return EndpointGroup.of(EndpointSelectionStrategy.weightedRoundRobin(), endpointGroups);
    }

    public static EndpointGroup of(EndpointSelectionStrategy selectionStrategy, EndpointGroup ... endpointGroups) {
        Objects.requireNonNull(endpointGroups, "endpointGroups");
        return EndpointGroup.of(selectionStrategy, ImmutableList.copyOf(endpointGroups));
    }

    public static EndpointGroup of(Iterable<? extends EndpointGroup> endpointGroups) {
        return EndpointGroup.of(EndpointSelectionStrategy.weightedRoundRobin(), endpointGroups);
    }

    public static EndpointGroup of(EndpointSelectionStrategy selectionStrategy, Iterable<? extends EndpointGroup> endpointGroups) {
        Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        Objects.requireNonNull(endpointGroups, "endpointGroups");
        ArrayList<EndpointGroup> groups = new ArrayList<EndpointGroup>();
        ArrayList<Endpoint> staticEndpoints = new ArrayList<Endpoint>();
        for (EndpointGroup endpointGroup : endpointGroups) {
            if (endpointGroup instanceof Endpoint) {
                staticEndpoints.add((Endpoint)endpointGroup);
                continue;
            }
            if (endpointGroup instanceof StaticEndpointGroup) {
                staticEndpoints.addAll(endpointGroup.endpoints());
                continue;
            }
            groups.add(endpointGroup);
        }
        if (groups.isEmpty() && staticEndpoints.isEmpty()) {
            return EndpointGroup.of();
        }
        if (groups.isEmpty()) {
            if (staticEndpoints.size() == 1) {
                return (EndpointGroup)staticEndpoints.get(0);
            }
            return new StaticEndpointGroup(selectionStrategy, staticEndpoints);
        }
        if (!staticEndpoints.isEmpty()) {
            groups.add(new StaticEndpointGroup(selectionStrategy, staticEndpoints));
        }
        if (groups.size() == 1) {
            return (EndpointGroup)groups.get(0);
        }
        return new CompositeEndpointGroup(selectionStrategy, groups);
    }

    public List<Endpoint> endpoints();

    public EndpointSelectionStrategy selectionStrategy();

    @Override
    @Nullable
    public Endpoint selectNow(ClientRequestContext var1);

    @UnstableApi
    public long selectionTimeoutMillis();

    public CompletableFuture<List<Endpoint>> whenReady();

    @Override
    default public void addListener(Consumer<? super List<Endpoint>> listener) {
        this.addListener(listener, false);
    }

    default public void addListener(Consumer<? super List<Endpoint>> listener, boolean notifyLatestEndpoints) {
    }

    @Override
    default public void removeListener(Consumer<?> listener) {
    }

    default public EndpointGroup orElse(EndpointGroup nextEndpointGroup) {
        return new OrElseEndpointGroup(this, nextEndpointGroup);
    }

    public static boolean isUndefined(EndpointGroup endpointGroup) {
        return UndefinedEndpointGroup.of() == endpointGroup;
    }
}

