/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerDecision;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRule;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleUtil;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleWithContentBuilder;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Streams;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface CircuitBreakerRuleWithContent<T extends Response> {
    public static <T extends Response> CircuitBreakerRuleWithContent<T> onResponse(BiFunction<? super ClientRequestContext, ? super T, ? extends CompletionStage<Boolean>> responseFilter) {
        return ((CircuitBreakerRuleWithContentBuilder)CircuitBreakerRuleWithContent.builder().onResponse(responseFilter)).thenFailure();
    }

    public static <T extends Response> CircuitBreakerRuleWithContentBuilder<T> builder() {
        return CircuitBreakerRuleWithContent.builder(HttpMethod.knownMethods());
    }

    public static <T extends Response> CircuitBreakerRuleWithContentBuilder<T> builder(HttpMethod ... methods) {
        return CircuitBreakerRuleWithContent.builder(ImmutableSet.copyOf(Objects.requireNonNull(methods, "methods")));
    }

    public static <T extends Response> CircuitBreakerRuleWithContentBuilder<T> builder(Iterable<HttpMethod> methods) {
        Objects.requireNonNull(methods, "methods");
        Preconditions.checkArgument(!Iterables.isEmpty(methods), "methods can't be empty.");
        ImmutableSet<HttpMethod> httpMethods = Sets.immutableEnumSet(methods);
        return CircuitBreakerRuleWithContent.builder((? super ClientRequestContext unused, ? super RequestHeaders headers) -> httpMethods.contains((Object)headers.method()));
    }

    public static <T extends Response> CircuitBreakerRuleWithContentBuilder<T> builder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        Objects.requireNonNull(requestHeadersFilter, "requestHeadersFilter");
        return new CircuitBreakerRuleWithContentBuilder(requestHeadersFilter);
    }

    @SafeVarargs
    public static <T extends Response> CircuitBreakerRuleWithContent<T> of(CircuitBreakerRuleWithContent<T> ... circuitBreakerRules) {
        Objects.requireNonNull(circuitBreakerRules, "circuitBreakerRules");
        Preconditions.checkArgument(circuitBreakerRules.length > 0, "circuitBreakerRules can't be empty.");
        if (circuitBreakerRules.length == 1) {
            return circuitBreakerRules[0];
        }
        return CircuitBreakerRuleWithContent.of(ImmutableList.copyOf(circuitBreakerRules));
    }

    public static <T extends Response> CircuitBreakerRuleWithContent<T> of(Iterable<? extends CircuitBreakerRuleWithContent<T>> circuitBreakerRules) {
        Objects.requireNonNull(circuitBreakerRules, "circuitBreakerRules");
        Preconditions.checkArgument(!Iterables.isEmpty(circuitBreakerRules), "circuitBreakerRules should not be empty.");
        if (Iterables.size(circuitBreakerRules) == 1) {
            return Iterables.get(circuitBreakerRules, 0);
        }
        Iterable<? extends CircuitBreakerRuleWithContent<T>> cast = circuitBreakerRules;
        return Streams.stream(cast).reduce(CircuitBreakerRuleWithContent::orElse).get();
    }

    default public CircuitBreakerRuleWithContent<T> orElse(CircuitBreakerRule other) {
        Objects.requireNonNull(other, "other");
        return CircuitBreakerRuleUtil.orElse(this, other);
    }

    default public CircuitBreakerRuleWithContent<T> orElse(CircuitBreakerRuleWithContent<T> other) {
        Objects.requireNonNull(other, "other");
        return CircuitBreakerRuleUtil.orElse(this, other);
    }

    public CompletionStage<CircuitBreakerDecision> shouldReportAsSuccess(ClientRequestContext var1, @Nullable T var2, @Nullable Throwable var3);

    default public boolean requiresResponseTrailers() {
        return false;
    }
}

