/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreaker;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerMapping;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.DefaultCircuitBreakerClientHandler;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.FailFastException;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.circuitbreaker.CircuitBreakerCallback;
import java.util.Objects;

@FunctionalInterface
@UnstableApi
public interface CircuitBreakerClientHandler {
    public static CircuitBreakerClientHandler of(CircuitBreaker circuitBreaker) {
        Objects.requireNonNull(circuitBreaker, "circuitBreaker");
        return CircuitBreakerClientHandler.of((ClientRequestContext ctx, Request req) -> circuitBreaker);
    }

    public static CircuitBreakerClientHandler of(CircuitBreakerMapping mapping) {
        return new DefaultCircuitBreakerClientHandler(Objects.requireNonNull(mapping, "mapping"));
    }

    @Nullable
    public CircuitBreakerCallback tryRequest(ClientRequestContext var1, Request var2);

    @UnstableApi
    default public boolean isCircuitBreakerException(Exception ex) {
        return ex instanceof FailFastException;
    }
}

