/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.FutureResponseAs;
import io.opentelemetry.testing.internal.armeria.client.ResponseAs;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.common.JacksonUtil;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

final class ResponseAsUtil {
    static final ObjectMapper OBJECT_MAPPER = JacksonUtil.newDefaultObjectMapper();
    static final Predicate<AggregatedHttpResponse> SUCCESS_PREDICATE = res -> res.status().isSuccess();
    static final ResponseAs<HttpResponse, AggregatedHttpResponse> BLOCKING = new ResponseAs<HttpResponse, AggregatedHttpResponse>(){

        @Override
        public AggregatedHttpResponse as(HttpResponse response) {
            Objects.requireNonNull(response, "response");
            try {
                return response.aggregate().join();
            }
            catch (Exception ex) {
                return (AggregatedHttpResponse)Exceptions.throwUnsafely(Exceptions.peel(ex));
            }
        }

        @Override
        public boolean requiresAggregation() {
            return true;
        }
    };

    static <T> FutureResponseAs<T> aggregateAndConvert(final ResponseAs<AggregatedHttpResponse, T> responseAs) {
        Objects.requireNonNull(responseAs, "responseAs");
        return new FutureResponseAs<T>(){

            @Override
            public CompletableFuture<T> as(HttpResponse response) {
                Objects.requireNonNull(response, "response");
                return response.aggregate().thenApply(responseAs::as);
            }

            @Override
            public boolean requiresAggregation() {
                return true;
            }
        };
    }

    private ResponseAsUtil() {
    }
}

