/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import java.net.URI;

final class DefaultClientBuilderParams
implements ClientBuilderParams {
    private final Scheme scheme;
    private final EndpointGroup endpointGroup;
    private final String absolutePathRef;
    private final URI uri;
    private final Class<?> type;
    private final ClientOptions options;

    DefaultClientBuilderParams(Scheme scheme, EndpointGroup endpointGroup, String absolutePathRef, URI uri, Class<?> type, ClientOptions options) {
        this.scheme = options.factory().validateScheme(scheme);
        this.endpointGroup = endpointGroup;
        this.absolutePathRef = absolutePathRef;
        this.uri = uri;
        this.type = type;
        this.options = options;
    }

    @Override
    public Scheme scheme() {
        return this.scheme;
    }

    @Override
    public EndpointGroup endpointGroup() {
        return this.endpointGroup;
    }

    @Override
    public String absolutePathRef() {
        return this.absolutePathRef;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Class<?> clientType() {
        return this.type;
    }

    @Override
    public ClientOptions options() {
        return this.options;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("scheme", this.scheme).add("endpointGroup", this.endpointGroup).add("absolutePathRef", this.absolutePathRef).add("type", this.type).add("options", this.options).toString();
    }
}

