/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.ClientFactory;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.DefaultClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientBuilderParamsUtil;
import io.opentelemetry.testing.internal.armeria.internal.client.endpoint.UndefinedEndpointGroup;
import io.opentelemetry.testing.internal.armeria.internal.common.util.TemporaryThreadLocals;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

@UnstableApi
public final class ClientBuilderParamsBuilder {
    private final URI uri;
    private final EndpointGroup endpointGroup;
    private final SessionProtocol sessionProtocol;
    private SerializationFormat serializationFormat;
    private String absolutePathRef;
    @Nullable
    private Class<?> type;
    @Nullable
    private ClientOptions options;

    ClientBuilderParamsBuilder(ClientBuilderParams params) {
        this.uri = params.uri();
        this.endpointGroup = params.endpointGroup();
        this.sessionProtocol = params.scheme().sessionProtocol();
        this.serializationFormat = params.scheme().serializationFormat();
        this.absolutePathRef = params.absolutePathRef();
        this.type = params.clientType();
        this.options = params.options();
    }

    ClientBuilderParamsBuilder(URI uri) {
        String absolutePathRef;
        this.uri = uri;
        Scheme scheme = Scheme.parse(uri.getScheme());
        EndpointGroup endpointGroup = ClientBuilderParamsUtil.isInternalUri(uri) ? UndefinedEndpointGroup.of() : Endpoint.parse(uri.getRawAuthority());
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append(ClientBuilderParamsUtil.nullOrEmptyToSlash(uri.getRawPath()));
            if (uri.getRawQuery() != null) {
                buf.append('?').append(uri.getRawQuery());
            }
            if (uri.getRawFragment() != null) {
                buf.append('#').append(uri.getRawFragment());
            }
            absolutePathRef = buf.toString();
        }
        this.endpointGroup = endpointGroup;
        this.serializationFormat = scheme.serializationFormat();
        this.sessionProtocol = scheme.sessionProtocol();
        this.absolutePathRef = absolutePathRef;
    }

    ClientBuilderParamsBuilder(Scheme scheme, EndpointGroup endpointGroup, @Nullable String absolutePathRef) {
        this.endpointGroup = endpointGroup;
        String schemeStr = scheme.shortUriText();
        String normalizedAbsolutePathRef = ClientBuilderParamsUtil.nullOrEmptyToSlash(absolutePathRef);
        URI uri = endpointGroup instanceof Endpoint ? URI.create(schemeStr + "://" + ((Endpoint)endpointGroup).authority() + normalizedAbsolutePathRef) : URI.create(schemeStr + "://" + "armeria-group-" + Integer.toHexString(System.identityHashCode(endpointGroup)) + ":1" + normalizedAbsolutePathRef);
        this.uri = uri;
        this.serializationFormat = scheme.serializationFormat();
        this.sessionProtocol = scheme.sessionProtocol();
        this.absolutePathRef = normalizedAbsolutePathRef;
    }

    public ClientBuilderParamsBuilder serializationFormat(SerializationFormat serializationFormat) {
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        return this;
    }

    public ClientBuilderParamsBuilder absolutePathRef(String absolutePathRef) {
        this.absolutePathRef = Objects.requireNonNull(absolutePathRef, "absolutePathRef");
        return this;
    }

    public ClientBuilderParamsBuilder clientType(Class<?> type) {
        this.type = Objects.requireNonNull(type, "type");
        return this;
    }

    public ClientBuilderParamsBuilder options(ClientOptions options) {
        this.options = Objects.requireNonNull(options, "options");
        return this;
    }

    public ClientBuilderParams build() {
        URI uri;
        ClientOptions options = Objects.requireNonNull(this.options, "options");
        Class<?> type = Objects.requireNonNull(this.type, "type");
        SerializationFormat serializationFormat = this.serializationFormat;
        String absolutePathRef = this.absolutePathRef;
        ClientFactory factory = options.factory();
        Scheme scheme = factory.validateScheme(Scheme.of(serializationFormat, this.sessionProtocol));
        String schemeStr = scheme.shortUriText();
        String path = ClientBuilderParamsUtil.nullOrEmptyToSlash(absolutePathRef);
        try {
            uri = new URI(schemeStr + "://" + this.uri.getRawAuthority() + path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return new DefaultClientBuilderParams(scheme, this.endpointGroup, path, factory.validateUri(uri), type, options);
    }
}

