/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.AbstractHttpRequestHandler;
import io.opentelemetry.testing.internal.armeria.client.ClientHttpObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.HttpResponseDecoder;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import java.util.function.BiFunction;

final class AggregatedHttpRequestHandler
extends AbstractHttpRequestHandler
implements BiFunction<AggregatedHttpRequest, Throwable, Void> {
    @Nullable
    private AggregatedHttpRequest request;
    private boolean cancelled;

    AggregatedHttpRequestHandler(Channel ch, ClientHttpObjectEncoder encoder, HttpResponseDecoder responseDecoder, HttpRequest request, DecodedHttpResponse originalRes, ClientRequestContext ctx, long timeoutMillis) {
        super(ch, encoder, responseDecoder, originalRes, ctx, timeoutMillis, request.isEmpty(), true, true);
    }

    @Override
    public Void apply(@Nullable AggregatedHttpRequest request, @Nullable Throwable throwable) {
        EventLoop eventLoop = this.channel().eventLoop();
        if (eventLoop.inEventLoop()) {
            this.apply0(request, throwable);
        } else {
            eventLoop.execute(() -> this.apply0(request, throwable));
        }
        return null;
    }

    private void apply0(@Nullable AggregatedHttpRequest request, @Nullable Throwable throwable) {
        if (throwable != null) {
            this.failRequest(throwable);
            return;
        }
        assert (request != null);
        RequestHeaders merged = this.mergedRequestHeaders(request.headers());
        boolean needs100Continue = AggregatedHttpRequestHandler.needs100Continue(merged);
        HttpData content = request.content();
        if (needs100Continue && content.isEmpty()) {
            content.close();
            this.failRequest(new IllegalArgumentException("an empty content is not allowed with Expect: 100-continue header"));
            return;
        }
        if (!this.tryInitialize()) {
            content.close();
            return;
        }
        this.writeHeaders(merged, needs100Continue);
        if (this.cancelled) {
            content.close();
            return;
        }
        if (!needs100Continue) {
            this.writeDataAndTrailers(request);
        } else {
            this.request = request;
        }
        this.channel().flush();
    }

    private void writeDataAndTrailers(AggregatedHttpRequest request) {
        HttpData content = request.content();
        boolean contentEmpty = content.isEmpty();
        HttpHeaders trailers = request.trailers();
        boolean trailersEmpty = trailers.isEmpty();
        if (!contentEmpty) {
            if (trailersEmpty) {
                this.writeData(content.withEndOfStream());
            } else {
                this.writeData(content);
            }
        }
        if (!trailersEmpty) {
            this.writeTrailers(trailers);
        }
    }

    @Override
    void onWriteSuccess() {
    }

    @Override
    void cancel() {
        this.cancelled = true;
    }

    @Override
    void resume() {
        assert (this.request != null);
        this.writeDataAndTrailers(this.request);
        this.channel().flush();
    }

    @Override
    void discardRequestBody() {
        assert (this.request != null);
        this.request.content().close();
    }
}

