/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachecommons.fileupload.util;

import io.opentelemetry.testing.internal.apachecommons.fileupload.util.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class LimitedInputStream
extends FilterInputStream
implements Closeable {
    private final long sizeMax;
    private long count;
    private boolean closed;

    public LimitedInputStream(InputStream inputStream, long sizeMax) {
        super(inputStream);
        this.sizeMax = sizeMax;
    }

    private void checkLimit() throws IOException {
        if (this.count > this.sizeMax) {
            this.raiseError(this.sizeMax, this.count);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.closed;
    }

    protected abstract void raiseError(long var1, long var3) throws IOException;

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.count;
            this.checkLimit();
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.count += (long)res;
            this.checkLimit();
        }
        return res;
    }
}

