/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.instrumentation.testing.InstrumentationTestRunner;
import io.opentelemetry.instrumentation.testing.LibraryTestRunner;
import io.opentelemetry.instrumentation.testing.util.ContextStorageCloser;
import io.opentelemetry.instrumentation.testing.util.ThrowingRunnable;
import io.opentelemetry.instrumentation.testing.util.ThrowingSupplier;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.testing.assertj.LogRecordDataAssert;
import io.opentelemetry.sdk.testing.assertj.MetricAssert;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import io.opentelemetry.sdk.testing.assertj.TraceAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class InstrumentationExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private final InstrumentationTestRunner testRunner;

    protected InstrumentationExtension(InstrumentationTestRunner testRunner) {
        this.testRunner = testRunner;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.testRunner.beforeTestClass();
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.testRunner.clearAllExportedData();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ContextStorage storage = ContextStorage.get();
        ContextStorageCloser.close(storage);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.testRunner.clearAllExportedData();
        this.testRunner.afterTestClass();
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.testRunner.getOpenTelemetry();
    }

    public List<SpanData> spans() {
        return this.testRunner.getExportedSpans();
    }

    public List<MetricData> metrics() {
        return this.testRunner.getExportedMetrics();
    }

    public List<LogRecordData> logRecords() {
        return this.testRunner.getExportedLogRecords();
    }

    public final void waitAndAssertMetrics(String instrumentationName, String metricName, Consumer<ListAssert<MetricData>> assertion) {
        this.testRunner.waitAndAssertMetrics(instrumentationName, metricName, assertion);
    }

    @SafeVarargs
    public final void waitAndAssertMetrics(String instrumentationName, Consumer<MetricAssert> ... assertions) {
        this.testRunner.waitAndAssertMetrics(instrumentationName, assertions);
    }

    public void clearData() {
        this.testRunner.clearAllExportedData();
    }

    public List<List<SpanData>> waitForTraces(int numberOfTraces) {
        return this.testRunner.waitForTraces(numberOfTraces);
    }

    public List<LogRecordData> waitForLogRecords(int numberOfLogRecords) {
        return this.testRunner.waitForLogRecords(numberOfLogRecords);
    }

    @SafeVarargs
    public final void waitAndAssertSortedTraces(Comparator<List<SpanData>> traceComparator, Consumer<TraceAssert> ... assertions) {
        this.testRunner.waitAndAssertSortedTraces(traceComparator, assertions);
    }

    public final void waitAndAssertSortedTraces(Comparator<List<SpanData>> traceComparator, Iterable<? extends Consumer<TraceAssert>> assertions) {
        this.testRunner.waitAndAssertSortedTraces(traceComparator, assertions);
    }

    @SafeVarargs
    public final void waitAndAssertTracesWithoutScopeVersionVerification(Consumer<TraceAssert> ... assertions) {
        this.testRunner.waitAndAssertTracesWithoutScopeVersionVerification(assertions);
    }

    @SafeVarargs
    public final void waitAndAssertTraces(Consumer<TraceAssert> ... assertions) {
        this.testRunner.waitAndAssertTraces(assertions);
    }

    public final void waitAndAssertTraces(Iterable<? extends Consumer<TraceAssert>> assertions) {
        this.testRunner.waitAndAssertTraces(assertions);
    }

    private void doWaitAndAssertLogRecords(List<Consumer<LogRecordDataAssert>> assertions) {
        List<LogRecordData> logRecordDataList = this.waitForLogRecords(assertions.size());
        Iterator<Consumer<LogRecordDataAssert>> assertionIterator = assertions.iterator();
        for (LogRecordData logRecordData : logRecordDataList) {
            assertionIterator.next().accept(OpenTelemetryAssertions.assertThat((LogRecordData)logRecordData));
        }
    }

    public final void waitAndAssertLogRecords(Iterable<? extends Consumer<LogRecordDataAssert>> assertions) {
        ArrayList<Consumer<LogRecordDataAssert>> assertionsList = new ArrayList<Consumer<LogRecordDataAssert>>();
        assertions.forEach(assertionsList::add);
        this.doWaitAndAssertLogRecords(assertionsList);
    }

    @SafeVarargs
    public final void waitAndAssertLogRecords(Consumer<LogRecordDataAssert> ... assertions) {
        this.doWaitAndAssertLogRecords(Arrays.asList(assertions));
    }

    public <E extends Exception> void runWithSpan(String spanName, ThrowingRunnable<E> callback) throws E {
        this.testRunner.runWithSpan(spanName, callback);
    }

    public <T, E extends Throwable> T runWithSpan(String spanName, ThrowingSupplier<T, E> callback) throws E {
        return this.testRunner.runWithSpan(spanName, callback);
    }

    public <E extends Throwable> void runWithHttpClientSpan(String spanName, ThrowingRunnable<E> callback) throws E {
        this.testRunner.runWithHttpClientSpan(spanName, callback);
    }

    public <T, E extends Throwable> T runWithHttpClientSpan(String spanName, ThrowingSupplier<T, E> callback) throws E {
        return this.testRunner.runWithHttpClientSpan(spanName, callback);
    }

    public <E extends Throwable> void runWithHttpServerSpan(ThrowingRunnable<E> callback) throws E {
        this.testRunner.runWithHttpServerSpan(callback);
    }

    public <T, E extends Throwable> T runWithHttpServerSpan(ThrowingSupplier<T, E> callback) throws E {
        return this.testRunner.runWithHttpServerSpan(callback);
    }

    public boolean forceFlushCalled() {
        return this.testRunner.forceFlushCalled();
    }

    public OpenTelemetrySdk getOpenTelemetrySdk() {
        if (this.testRunner instanceof LibraryTestRunner) {
            return ((LibraryTestRunner)this.testRunner).getOpenTelemetrySdk();
        }
        throw new IllegalStateException("Can only be called from library instrumentation tests.");
    }

    protected InstrumentationTestRunner getTestRunner() {
        return this.testRunner;
    }
}

