/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.internal;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class AutoCleanupExtension
implements AfterEachCallback {
    private final Queue<AutoCloseable> thingsToCleanUp = new ConcurrentLinkedQueue<AutoCloseable>();

    private AutoCleanupExtension() {
    }

    public static AutoCleanupExtension create() {
        return new AutoCleanupExtension();
    }

    public void deferCleanup(AutoCloseable cleanupAction) {
        this.thingsToCleanUp.add(cleanupAction);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        while (!this.thingsToCleanUp.isEmpty()) {
            try {
                this.thingsToCleanUp.poll().close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        switch (exceptions.size()) {
            case 0: {
                return;
            }
            case 1: {
                throw (Exception)exceptions.get(0);
            }
        }
        AssertionError allFailures = new AssertionError((Object)"Multiple cleanup errors occurred");
        exceptions.forEach(arg_0 -> allFailures.addSuppressed(arg_0));
        throw allFailures;
    }
}

