/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.incubator.config.GlobalConfigProvider;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.contrib.baggage.processor.BaggageSpanProcessor;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.instrumentation.testing.InstrumentationTestRunner;
import io.opentelemetry.instrumentation.testing.internal.MetaDataCollector;
import io.opentelemetry.instrumentation.testing.provider.TestLogRecordExporterComponentProvider;
import io.opentelemetry.instrumentation.testing.provider.TestMetricExporterComponentProvider;
import io.opentelemetry.instrumentation.testing.provider.TestSpanExporterComponentProvider;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryLogRecordExporter;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricExporter;
import io.opentelemetry.sdk.testing.exporter.InMemorySpanExporter;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class LibraryTestRunner
extends InstrumentationTestRunner {
    private static final OpenTelemetrySdk openTelemetrySdk;
    private static final OpenTelemetry openTelemetry;
    private static final InMemorySpanExporter testSpanExporter;
    private static final InMemoryMetricExporter testMetricExporter;
    private static final InMemoryLogRecordExporter testLogRecordExporter;
    private static final MetricReader metricReader;
    private static boolean forceFlushCalled;
    private static final LibraryTestRunner INSTANCE;

    public static LibraryTestRunner instance() {
        return INSTANCE;
    }

    private LibraryTestRunner() {
        super(openTelemetry);
    }

    @Override
    public void beforeTestClass() {
        GlobalOpenTelemetry.resetForTest();
        GlobalConfigProvider.resetForTest();
        GlobalOpenTelemetry.set((OpenTelemetry)openTelemetrySdk);
    }

    @Override
    public void afterTestClass() throws IOException {
        if (Boolean.getBoolean("collectMetadata")) {
            URL resource = this.getClass().getClassLoader().getResource("");
            if (resource == null) {
                return;
            }
            String path = Paths.get(resource.getPath(), new String[0]).toString();
            MetaDataCollector.writeTelemetryToFiles(path, this.metricsByScope, this.tracesByScope);
        }
    }

    @Override
    public void clearAllExportedData() {
        openTelemetrySdk.getSdkMeterProvider().forceFlush().join(10L, TimeUnit.SECONDS);
        testSpanExporter.reset();
        testMetricExporter.reset();
        testLogRecordExporter.reset();
        forceFlushCalled = false;
    }

    @Override
    public OpenTelemetry getOpenTelemetry() {
        return openTelemetry;
    }

    public OpenTelemetrySdk getOpenTelemetrySdk() {
        return openTelemetrySdk;
    }

    @Override
    public List<SpanData> getExportedSpans() {
        return testSpanExporter.getFinishedSpanItems();
    }

    @Override
    public List<MetricData> getExportedMetrics() {
        metricReader.forceFlush().join(10L, TimeUnit.SECONDS);
        return testMetricExporter.getFinishedMetricItems();
    }

    @Override
    public List<LogRecordData> getExportedLogRecords() {
        return testLogRecordExporter.getFinishedLogRecordItems();
    }

    @Override
    public boolean forceFlushCalled() {
        return forceFlushCalled;
    }

    private static OpenTelemetry wrap(final OpenTelemetry delegate) {
        return new OpenTelemetry(){

            public TracerProvider getTracerProvider() {
                return delegate.getTracerProvider();
            }

            public MeterProvider getMeterProvider() {
                return delegate.getMeterProvider();
            }

            public LoggerProvider getLogsBridge() {
                return delegate.getLogsBridge();
            }

            public ContextPropagators getPropagators() {
                return delegate.getPropagators();
            }

            public TracerBuilder tracerBuilder(String instrumentationScopeName) {
                return delegate.tracerBuilder(instrumentationScopeName);
            }
        };
    }

    static {
        GlobalOpenTelemetry.resetForTest();
        GlobalConfigProvider.resetForTest();
        testSpanExporter = InMemorySpanExporter.create();
        testMetricExporter = InMemoryMetricExporter.create((AggregationTemporality)AggregationTemporality.DELTA);
        testLogRecordExporter = InMemoryLogRecordExporter.create();
        TestSpanExporterComponentProvider.setSpanExporter((SpanExporter)testSpanExporter);
        TestMetricExporterComponentProvider.setMetricExporter((MetricExporter)testMetricExporter);
        TestLogRecordExporterComponentProvider.setLogRecordExporter((LogRecordExporter)testLogRecordExporter);
        metricReader = PeriodicMetricReader.builder((MetricExporter)testMetricExporter).setInterval(Duration.ofNanos(Long.MAX_VALUE)).build();
        openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)new FlushTrackingSpanProcessor()).addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)LoggingSpanExporter.create())).addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)testSpanExporter)).addSpanProcessor((SpanProcessor)new BaggageSpanProcessor(baggageKey -> Arrays.asList("test-baggage-key-1", "test-baggage-key-2").contains(baggageKey))).build()).setMeterProvider(SdkMeterProvider.builder().registerMetricReader(metricReader).build()).setLoggerProvider(SdkLoggerProvider.builder().addLogRecordProcessor(SimpleLogRecordProcessor.create((LogRecordExporter)testLogRecordExporter)).build()).setPropagators(ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()}))).buildAndRegisterGlobal();
        openTelemetry = LibraryTestRunner.wrap((OpenTelemetry)openTelemetrySdk);
        INSTANCE = new LibraryTestRunner();
    }

    private static class FlushTrackingSpanProcessor
    implements SpanProcessor {
        private FlushTrackingSpanProcessor() {
        }

        public void onStart(Context parentContext, ReadWriteSpan span) {
        }

        public boolean isStartRequired() {
            return false;
        }

        public void onEnd(ReadableSpan span) {
        }

        public boolean isEndRequired() {
            return false;
        }

        public CompletableResultCode forceFlush() {
            forceFlushCalled = true;
            return CompletableResultCode.ofSuccess();
        }
    }
}

