/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import io.opentelemetry.testing.internal.servlet.Filter;
import io.opentelemetry.testing.internal.servlet.FilterChain;
import io.opentelemetry.testing.internal.servlet.FilterConfig;
import io.opentelemetry.testing.internal.servlet.ServletContext;
import io.opentelemetry.testing.internal.servlet.ServletException;
import io.opentelemetry.testing.internal.servlet.ServletRequest;
import io.opentelemetry.testing.internal.servlet.ServletResponse;
import io.opentelemetry.testing.internal.servlet.http.HttpServletRequest;
import io.opentelemetry.testing.internal.servlet.http.HttpServletResponse;
import java.io.IOException;

public class ContentTypeSettingFilter
implements Filter {
    private ServletContext context;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            String filePath = ((HttpServletRequest)request).getRequestURI();
            String contentType = this.context.getMimeType(filePath);
            if (contentType == null) {
                contentType = "application/json";
            }
            ((HttpServletResponse)response).setContentType(contentType);
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}

