/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.recording.CaptureHeadersSpec;
import com.github.tomakehurst.wiremock.recording.ProxiedServeEventFilters;
import com.github.tomakehurst.wiremock.recording.RequestBodyAutomaticPatternFactory;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import com.github.tomakehurst.wiremock.recording.SnapshotOutputFormatter;
import io.opentelemetry.testing.internal.jackson.annotation.JsonCreator;
import io.opentelemetry.testing.internal.jackson.annotation.JsonIgnore;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public class RecordSpec {
    private final String targetBaseUrl;
    private final ProxiedServeEventFilters filters;
    private final Map<String, CaptureHeadersSpec> captureHeaders;
    private final RequestBodyPatternFactory requestBodyPatternFactory;
    private final ResponseDefinitionBodyMatcher extractBodyCriteria;
    private final SnapshotOutputFormatter outputFormat;
    private final Boolean persist;
    private final Boolean repeatsAsScenarios;
    private final List<String> transformers;
    private final Parameters transformerParameters;
    public static final RecordSpec DEFAULTS = new RecordSpec();

    @JsonCreator
    public RecordSpec(@JsonProperty(value="targetBaseUrl") String targetBaseUrl, @JsonProperty(value="filters") ProxiedServeEventFilters filters, @JsonProperty(value="captureHeaders") Map<String, CaptureHeadersSpec> captureHeaders, @JsonProperty(value="requestBodyPattern") RequestBodyPatternFactory requestBodyPatternFactory, @JsonProperty(value="extractBodyCriteria") ResponseDefinitionBodyMatcher extractBodyCriteria, @JsonProperty(value="outputFormat") SnapshotOutputFormatter outputFormat, @JsonProperty(value="persist") Boolean persist, @JsonProperty(value="repeatsAsScenarios") Boolean repeatsAsScenarios, @JsonProperty(value="transformers") List<String> transformers, @JsonProperty(value="transformerParameters") Parameters transformerParameters) {
        this.targetBaseUrl = targetBaseUrl;
        this.filters = filters == null ? ProxiedServeEventFilters.ALLOW_ALL : filters;
        this.captureHeaders = captureHeaders;
        this.requestBodyPatternFactory = requestBodyPatternFactory == null ? RequestBodyAutomaticPatternFactory.DEFAULTS : requestBodyPatternFactory;
        this.extractBodyCriteria = extractBodyCriteria;
        this.outputFormat = outputFormat == null ? SnapshotOutputFormatter.FULL : outputFormat;
        this.persist = persist == null ? true : persist;
        this.repeatsAsScenarios = repeatsAsScenarios;
        this.transformers = transformers;
        this.transformerParameters = transformerParameters;
    }

    private RecordSpec() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    public static RecordSpec forBaseUrl(String targetBaseUrl) {
        return new RecordSpec(targetBaseUrl, null, null, null, null, null, null, true, null, null);
    }

    public String getTargetBaseUrl() {
        return this.targetBaseUrl;
    }

    public ProxiedServeEventFilters getFilters() {
        return this.filters;
    }

    public Map<String, CaptureHeadersSpec> getCaptureHeaders() {
        return this.captureHeaders;
    }

    public SnapshotOutputFormatter getOutputFormat() {
        return this.outputFormat;
    }

    @JsonProperty(value="persist")
    public boolean shouldPersist() {
        return this.persist;
    }

    @JsonIgnore
    public boolean shouldRecordRepeatsAsScenarios() {
        return this.repeatsAsScenarios == null ? true : this.repeatsAsScenarios;
    }

    public Boolean getRepeatsAsScenarios() {
        return this.repeatsAsScenarios;
    }

    public List<String> getTransformers() {
        return this.transformers;
    }

    public Parameters getTransformerParameters() {
        return this.transformerParameters;
    }

    public ResponseDefinitionBodyMatcher getExtractBodyCriteria() {
        return this.extractBodyCriteria;
    }

    public RequestBodyPatternFactory getRequestBodyPatternFactory() {
        return this.requestBodyPatternFactory;
    }
}

