/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePatternJsonDeserializer;
import io.opentelemetry.testing.internal.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.core.JsonProcessingException;
import io.opentelemetry.testing.internal.jackson.databind.DeserializationContext;
import io.opentelemetry.testing.internal.jackson.databind.JsonDeserializer;
import io.opentelemetry.testing.internal.jackson.databind.JsonMappingException;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Map;

public class ContentPatternDeserialiser
extends JsonDeserializer<ContentPattern<?>> {
    @Override
    public ContentPattern<?> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (ContentPatternDeserialiser.isAbsent(rootNode)) {
            return AbsentPattern.ABSENT;
        }
        if (rootNode.has("binaryEqualTo")) {
            return this.deserializeBinaryEqualTo(rootNode);
        }
        return new StringValuePatternJsonDeserializer().buildStringValuePattern(rootNode);
    }

    private BinaryEqualToPattern deserializeBinaryEqualTo(JsonNode rootNode) throws JsonMappingException {
        String operand = rootNode.findValue("binaryEqualTo").textValue();
        return new BinaryEqualToPattern(operand);
    }

    private static boolean isAbsent(JsonNode rootNode) {
        for (Map.Entry entry : ImmutableList.copyOf(rootNode.fields())) {
            if (!((String)entry.getKey()).equals("absent")) continue;
            return true;
        }
        return false;
    }
}

