/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Limit;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Response;
import io.opentelemetry.testing.internal.guava.net.MediaType;
import io.opentelemetry.testing.internal.jackson.annotation.JsonIgnore;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;
import java.nio.charset.Charset;

public class LoggedResponse {
    private final int status;
    private final HttpHeaders headers;
    private final byte[] body;
    private final Fault fault;

    public LoggedResponse(@JsonProperty(value="status") int status, @JsonProperty(value="headers") HttpHeaders headers, @JsonProperty(value="bodyAsBase64") String bodyAsBase64, @JsonProperty(value="fault") Fault fault, @JsonProperty(value="body") String ignoredBodyOnlyUsedForBinding) {
        this(status, headers, Encoding.decodeBase64(bodyAsBase64), fault);
    }

    private LoggedResponse(int status, HttpHeaders headers, byte[] body, Fault fault) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.fault = fault;
    }

    public static LoggedResponse from(Response response, Limit responseBodySizeLimit) {
        return new LoggedResponse(response.getStatus(), response.getHeaders() == null || response.getHeaders().all().isEmpty() ? null : response.getHeaders(), response.getBody(responseBodySizeLimit), response.getFault());
    }

    public int getStatus() {
        return this.status;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @JsonProperty(value="body")
    public String getBodyAsString() {
        if (this.body == null) {
            return "";
        }
        return Strings.stringFromBytes(this.body, this.getCharset());
    }

    @JsonIgnore
    public String getMimeType() {
        return this.headers == null || this.headers.getContentTypeHeader() == null ? MediaType.OCTET_STREAM.toString() : this.headers.getContentTypeHeader().mimeTypePart();
    }

    @JsonIgnore
    public Charset getCharset() {
        return this.headers == null ? Strings.DEFAULT_CHARSET : this.headers.getContentTypeHeader().charset();
    }

    @JsonIgnore
    public byte[] getBody() {
        return this.body;
    }

    @JsonProperty(value="bodyAsBase64")
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.body);
    }

    public Fault getFault() {
        return this.fault;
    }
}

