/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.databind.JsonSerializer;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import java.io.IOException;

public class HttpHeadersJsonSerializer
extends JsonSerializer<HttpHeaders> {
    @Override
    public void serialize(HttpHeaders headers, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        for (HttpHeader header : headers.all()) {
            if (header.isSingleValued()) {
                jgen.writeStringField(header.key(), header.firstValue());
                continue;
            }
            jgen.writeArrayFieldStart(header.key());
            for (String value : header.values()) {
                jgen.writeString(value);
            }
            jgen.writeEndArray();
        }
        jgen.writeEndObject();
    }
}

