/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import io.opentelemetry.testing.internal.guava.base.Function;
import io.opentelemetry.testing.internal.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.guava.collect.Iterables;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.databind.DeserializationContext;
import io.opentelemetry.testing.internal.jackson.databind.JsonDeserializer;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class HttpHeadersJsonDeserializer
extends JsonDeserializer<HttpHeaders> {
    @Override
    public HttpHeaders deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        return new HttpHeaders(Iterables.transform(HttpHeadersJsonDeserializer.all(rootNode.fields()), HttpHeadersJsonDeserializer.toHttpHeaders()));
    }

    private static Function<Map.Entry<String, JsonNode>, HttpHeader> toHttpHeaders() {
        return new Function<Map.Entry<String, JsonNode>, HttpHeader>(){

            @Override
            public HttpHeader apply(Map.Entry<String, JsonNode> field) {
                String key = field.getKey();
                if (field.getValue().isArray()) {
                    return new HttpHeader(key, (Collection<String>)ImmutableList.copyOf(Iterables.transform(HttpHeadersJsonDeserializer.all(field.getValue().elements()), HttpHeadersJsonDeserializer.toStringValues())));
                }
                return new HttpHeader(key, field.getValue().textValue());
            }
        };
    }

    private static Function<JsonNode, String> toStringValues() {
        return new Function<JsonNode, String>(){

            @Override
            public String apply(JsonNode node) {
                return node.textValue();
            }
        };
    }

    public static <T> Iterable<T> all(final Iterator<T> underlyingIterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return underlyingIterator;
            }
        };
    }
}

