/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.core.JsonProcessingException;
import io.opentelemetry.testing.internal.jackson.databind.JsonSerializer;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import io.opentelemetry.testing.internal.jackson.databind.type.CollectionType;
import io.opentelemetry.testing.internal.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;

public class ListOrSingleSerialiser
extends JsonSerializer<ListOrSingle<Object>> {
    @Override
    public void serialize(ListOrSingle<Object> value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (value.isEmpty()) {
            gen.writeStartArray();
            gen.writeEndArray();
            return;
        }
        Object firstValue = value.getFirst();
        if (value.isSingle()) {
            JsonSerializer<Object> serializer = serializers.findValueSerializer(firstValue.getClass());
            serializer.serialize(firstValue, gen, serializers);
        } else {
            CollectionType type = TypeFactory.defaultInstance().constructCollectionType(List.class, firstValue.getClass());
            JsonSerializer<Object> serializer = serializers.findValueSerializer(type);
            serializer.serialize(value, gen, serializers);
        }
    }
}

