/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import io.opentelemetry.testing.internal.apachehttp.core5.http.ClassicHttpResponse;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpEntity;
import io.opentelemetry.testing.internal.apachehttp.core5.http.ParseException;
import io.opentelemetry.testing.internal.apachehttp.core5.http.io.entity.EntityUtils;
import io.opentelemetry.testing.internal.guava.base.Charsets;
import java.io.IOException;

public class HttpClientUtils {
    public static String getEntityAsStringAndCloseStream(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                String content = EntityUtils.toString(entity, Charsets.UTF_8.name());
                entity.getContent().close();
                return content;
            }
            catch (ParseException | IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }

    public static byte[] getEntityAsByteArrayAndCloseStream(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                byte[] content = EntityUtils.toByteArray(entity);
                entity.getContent().close();
                return content;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }
}

