/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST>> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private static final String SQL_CALL = "CALL";
    private final AttributeKey<String> dbTableAttribute;
    private final SqlStatementSanitizer sanitizer;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientAttributesExtractorBuilder(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter, AttributeKey<String> dbTableAttribute, SqlStatementSanitizer sanitizer) {
        super(getter);
        this.dbTableAttribute = dbTableAttribute;
        this.sanitizer = sanitizer;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        SqlStatementInfo sanitizedStatement = this.sanitizer.sanitize(((SqlClientAttributesGetter)this.getter).getRawStatement(request));
        String operation = sanitizedStatement.getOperation();
        AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, sanitizedStatement.getFullStatement());
        AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, operation);
        if (!SQL_CALL.equals(operation)) {
            AttributesExtractorUtil.internalSet(attributes, this.dbTableAttribute, sanitizedStatement.getMainIdentifier());
        }
    }
}

