/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http.HttpClientExperimentalAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http.HttpClientUrlTemplate;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http.HttpClientUrlTemplateCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.InstrumenterContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ServiceLoaderUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class HttpClientUrlTemplateUtil {
    private static final List<HttpClientUrlTemplateCustomizer> customizers = new ArrayList<HttpClientUrlTemplateCustomizer>();

    @Nullable
    public static <REQUEST> String getUrlTemplate(Context context, REQUEST request, HttpClientAttributesGetter<REQUEST, ?> getter) {
        String urlTemplate = HttpClientUrlTemplate.get(context);
        if (urlTemplate == null && getter instanceof HttpClientExperimentalAttributesGetter) {
            HttpClientExperimentalAttributesGetter experimentalGetter = (HttpClientExperimentalAttributesGetter)getter;
            urlTemplate = experimentalGetter.getUrlTemplate(request);
        }
        return HttpClientUrlTemplateUtil.customizeUrlTemplate(urlTemplate, request, getter);
    }

    @Nullable
    private static <REQUEST> String customizeUrlTemplate(@Nullable String urlTemplate, REQUEST request, HttpClientAttributesGetter<REQUEST, ?> getter) {
        if (customizers.isEmpty()) {
            return urlTemplate;
        }
        return InstrumenterContext.computeIfAbsent("url.template", unused -> {
            for (HttpClientUrlTemplateCustomizer customizer : customizers) {
                String result = customizer.customize(urlTemplate, request, getter);
                if (result == null) continue;
                return result;
            }
            return urlTemplate;
        });
    }

    private HttpClientUrlTemplateUtil() {
    }

    static {
        for (HttpClientUrlTemplateCustomizer customizer : ServiceLoaderUtil.load(HttpClientUrlTemplateCustomizer.class)) {
            customizers.add(customizer);
        }
    }
}

