/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.builder.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.config.internal.CommonConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http.HttpServerExperimentalMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerRouteBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public final class DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> {
    private final String instrumentationName;
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> additionalExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    private UnaryOperator<SpanStatusExtractor<REQUEST, RESPONSE>> spanStatusExtractorCustomizer = UnaryOperator.identity();
    private final HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> httpAttributesExtractorBuilder;
    private final HttpSpanNameExtractorBuilder<REQUEST> httpSpanNameExtractorBuilder;
    @Nullable
    private final TextMapGetter<REQUEST> headerGetter;
    private UnaryOperator<SpanNameExtractor<REQUEST>> spanNameExtractorCustomizer = UnaryOperator.identity();
    private final HttpServerRouteBuilder<REQUEST> httpServerRouteBuilder;
    private final HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private boolean emitExperimentalHttpServerTelemetry = false;
    private Consumer<InstrumenterBuilder<REQUEST, RESPONSE>> builderCustomizer = b -> {};

    private DefaultHttpServerInstrumenterBuilder(String instrumentationName, OpenTelemetry openTelemetry, HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter, @Nullable TextMapGetter<REQUEST> headerGetter) {
        this.instrumentationName = Objects.requireNonNull(instrumentationName, "instrumentationName");
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry");
        this.attributesGetter = Objects.requireNonNull(attributesGetter, "attributesGetter");
        this.httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder(attributesGetter);
        this.httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder(attributesGetter);
        this.httpServerRouteBuilder = HttpServerRoute.builder(attributesGetter);
        this.headerGetter = headerGetter;
    }

    public static <REQUEST, RESPONSE> DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> create(String instrumentationName, OpenTelemetry openTelemetry, HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        return new DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE>(instrumentationName, openTelemetry, attributesGetter, null);
    }

    public static <REQUEST, RESPONSE> DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> create(String instrumentationName, OpenTelemetry openTelemetry, HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter, TextMapGetter<REQUEST> headerGetter) {
        return new DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE>(instrumentationName, openTelemetry, attributesGetter, Objects.requireNonNull(headerGetter, "headerGetter"));
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setSpanStatusExtractorCustomizer(UnaryOperator<SpanStatusExtractor<REQUEST, RESPONSE>> spanStatusExtractorCustomizer) {
        this.spanStatusExtractorCustomizer = spanStatusExtractorCustomizer;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(Collection<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(Collection<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setKnownMethods(Collection<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        this.httpServerRouteBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setEmitExperimentalHttpServerTelemetry(boolean emitExperimentalHttpServerTelemetry) {
        this.emitExperimentalHttpServerTelemetry = emitExperimentalHttpServerTelemetry;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setSpanNameExtractorCustomizer(UnaryOperator<SpanNameExtractor<REQUEST>> spanNameExtractorCustomizer) {
        this.spanNameExtractorCustomizer = spanNameExtractorCustomizer;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setBuilderCustomizer(Consumer<InstrumenterBuilder<REQUEST, RESPONSE>> builderCustomizer) {
        this.builderCustomizer = builderCustomizer;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> build() {
        InstrumenterBuilder builder = this.instrumenterBuilder();
        if (this.headerGetter != null) {
            return builder.buildServerInstrumenter(this.headerGetter);
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysServer());
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> instrumenterBuilder() {
        SpanNameExtractor spanNameExtractor = (SpanNameExtractor)this.spanNameExtractorCustomizer.apply(this.httpSpanNameExtractorBuilder.build());
        InstrumenterBuilder<REQUEST, RESPONSE> builder = Instrumenter.builder(this.openTelemetry, this.instrumentationName, spanNameExtractor).setSpanStatusExtractor((SpanStatusExtractor)this.spanStatusExtractorCustomizer.apply(HttpSpanStatusExtractor.create(this.attributesGetter))).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addContextCustomizer(this.httpServerRouteBuilder.build()).addOperationMetrics(HttpServerMetrics.get()).setSchemaUrl("https://opentelemetry.io/schemas/1.37.0");
        if (this.emitExperimentalHttpServerTelemetry) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create(this.attributesGetter)).addOperationMetrics(HttpServerExperimentalMetrics.get());
        }
        this.builderCustomizer.accept(builder);
        return builder;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> configure(CommonConfig config) {
        DefaultHttpServerInstrumenterBuilder.set(config::getKnownHttpRequestMethods, this::setKnownMethods);
        DefaultHttpServerInstrumenterBuilder.set(config::getServerRequestHeaders, this::setCapturedRequestHeaders);
        DefaultHttpServerInstrumenterBuilder.set(config::getServerResponseHeaders, this::setCapturedResponseHeaders);
        DefaultHttpServerInstrumenterBuilder.set(config::shouldEmitExperimentalHttpServerTelemetry, this::setEmitExperimentalHttpServerTelemetry);
        return this;
    }

    private static <T> void set(Supplier<T> supplier, Consumer<T> consumer) {
        T t = supplier.get();
        if (t != null) {
            consumer.accept(t);
        }
    }
}

