/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.config.internal.DeclarativeConfigUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import java.util.Collections;
import java.util.List;

public final class ExperimentalConfig {
    private static final ExperimentalConfig instance = new ExperimentalConfig(GlobalOpenTelemetry.get());
    private final DeclarativeConfigProperties commonConfig;
    private final List<String> messagingHeaders;

    public static ExperimentalConfig get() {
        return instance;
    }

    public ExperimentalConfig(OpenTelemetry openTelemetry) {
        this.commonConfig = DeclarativeConfigUtil.getInstrumentationConfig(openTelemetry, "common");
        this.messagingHeaders = this.commonConfig.get("messaging").getScalarList("capture_headers/development", String.class, Collections.emptyList());
    }

    public boolean controllerTelemetryEnabled() {
        return this.commonConfig.get("controller_telemetry/development").getBoolean("enabled", false);
    }

    public boolean viewTelemetryEnabled() {
        return this.commonConfig.get("view_telemetry/development").getBoolean("enabled", false);
    }

    public boolean messagingReceiveInstrumentationEnabled() {
        return this.commonConfig.get("messaging").get("receive_telemetry/development").getBoolean("enabled", false);
    }

    public List<String> getMessagingHeaders() {
        return this.messagingHeaders;
    }
}

